/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<string> coll1 = { "Ahoj", "to", "jest", "prosty", "przykład" };
    list<string> coll2;

    // kopiuj elementy coll1 do coll2
    // - użyj iteratora wstawiającego w celu uniknięcia nadpisywania elementów
    // - użyj copy() ponieważ elementy w coll1 będą użyte ponownie
    copy (coll1.cbegin(), coll1.cend(),         // zakres źródłowy
          back_inserter(coll2));                // zakres docelowy

    // wypisz elementy coll2
    // - kopiuj elementy do strumienia cout za pomocą iteratora strumienia wyjściowego
    // - użyj move() ponieważ elementy coll2 nie będą użyte ponownie
    move (coll2.cbegin(), coll2.cend(),         // zakres źródłowy
          ostream_iterator<string>(cout," "));  // zakres docelowy
    cout << endl;

    // przenieś elementy coll1 do coll2 w odwrotnej kolejności
    // - nadpisuj elementy (coll2.size() ma już odpowiednią wartość)
    // - użyj move() ponieważ elementy coll2 nie będą użyte ponownie
    move (coll1.crbegin(), coll1.crend(),       // zakres źródłowy
          coll2.begin());                       // zakres docelowy

    // ponownie wypisz elementy coll2
    // - użyj move() ponieważ elementy coll2 nie będą użyte ponownie
    move (coll2.cbegin(), coll2.cend(),         // zakres źródłowy
          ostream_iterator<string>(cout," "));  // destination range
    cout << endl;
}
