/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,1,6);
    PRINT_ELEMENTS(coll);

    // oblicz sumę wszystkich iloczynów
    // (0 + 1*1 + 2*2 + 3*3 + 4*4 + 5*5 + 6*6)
    cout << "iloczyn skalarny: "
         << inner_product (coll.cbegin(), coll.cend(),  // pierwszy zakres
                           coll.cbegin(),               // drugi zakres
                           0)                           // wartość początkowa
         << endl;

    // oblicz sumę 1*6 ... 6*1
    // (0 + 1*6 + 2*5 + 3*4 + 4*3 + 5*2 + 6*1)
    cout << "odwrotny iloczyn skalarny: "
         << inner_product (coll.cbegin(), coll.cend(),  // pierwszy zakres
                           coll.crbegin(),              // drugi zakres
                           0)                           // wartość początkowa
         << endl;

    // oblicz iloczym wszystkich sum
    // (1 * 1+1 * 2+2 * 3+3 * 4+4 * 5+5 * 6+6)
    cout << "iloczyn sum: "
         << inner_product (coll.cbegin(), coll.cend(),  // pierwszy zakres
                           coll.cbegin(),               // drugi zakres
                           1,                           // wartość początkowa
                           multiplies<int>(),           // outer operation
                           plus<int>())                 // inner operation
         << endl;
}
