/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <list>
#include <algorithm>
#include <iterator>
#include "print.hpp"
using namespace std;

int main()
{
    list<int> coll;

    // utwórz wstawiacz początkowy dla kontenera coll
    // - niewygodny sposób
    front_insert_iterator<list<int> > iter(coll);

    // wstaw elementy z wykorzystaniem typowego interfejsu iteratora
    *iter = 1;
    iter++;
    *iter = 2;
    iter++;
    *iter = 3;

    PRINT_ELEMENTS(coll);

    // utwórz wstawiacz początkowy i wstaw elementy
    // - wygodny sposób
    front_inserter(coll) = 44;
    front_inserter(coll) = 55;

    PRINT_ELEMENTS(coll);

    // użyj wstawiacza początkowego do ponownego wstawienia wszystkich elementów
    copy (coll.begin(), coll.end(),    // źródło
          front_inserter(coll));       // przeznaczenie

    PRINT_ELEMENTS(coll);
}
