/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <exception>
#include "Stack.hpp"      // wykorzystaj specjalną klasę stosu
using namespace std;

int main()
{
   try {
      Stack<int> st;

      // odłóż na stos trzy elementy
      st.push(1);
      st.push(2);
      st.push(3);

      // zdejmij ze stosu dwa elementy i wypisz je
      cout << st.pop() << ' ';
      cout << st.pop() << ' ';

      // zmodyfikuj kolejny element
      st.top() = 77;

      // dodaj dwa nowe elementy
      st.push(4);
      st.push(5);

      // pobierz jeden element bez jego przetwarzania
      st.pop();

      // pobierz trzy elementy i je wypisz
      // BŁĄD: o jeden element za dużo
      cout << st.pop() << ' ';
      cout << st.pop() << endl;
      cout << st.pop() << endl;
   }
   catch (const exception& e) {
      cerr << "WYJĄTEK: " << e.what() << endl;
   }
}

