/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <iomanip>
#include <utility>
#include <iterator>
#include <typeinfo>

// generic output for pairs (map elements)
template <typename T1, typename T2>
std::ostream& operator << (std::ostream& strm, const std::pair<T1,T2>& p)
{
    return strm << "[" << p.first << "," << p.second << "]";
}

template <typename T>
void printHashTableState (const T& cont)
{
    // podstawowe dane dotyczące układu wewnętrznego:
    std::cout << "rozmiar:               " << cont.size() << "\n";
    std::cout << "liczba kubelkow:       " << cont.bucket_count() << "\n";
    std::cout << "wsp. obciazenia:       " << cont.load_factor() << "\n";
    std::cout << "maks. wsp. obciazenia: " << cont.max_load_factor() << "\n";

    // kategoria iteratora:
    if (typeid(typename std::iterator_traits
                          <typename T::iterator>::iterator_category)
        == typeid(std::bidirectional_iterator_tag)) {
          std::cout << "typ połączenia:  lista dwukierunkowa" << "\n";
    }
    else {
          std::cout << "typ połączenia:  lista jednokierunkowa" << "\n";
    }

    // elementy w kubełkach:
    std::cout << "dane: " << "\n";
    for (auto idx=0u; idx != cont.bucket_count(); ++idx) {
            std::cout << " b[" << std::setw(2) << idx << "]: ";
            for (auto pos=cont.begin(idx); pos != cont.end(idx); ++pos) {
                std::cout << *pos << " ";
            }
            std::cout << "\n";
    }
    std::cout << std::endl;
}
