/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <iostream>
#include <algorithm>
using namespace std;

int main()
{
    // utwórz łańcuch znakowy
    const string hello("Cześć, jak się miewasz?");

    // utwórz łańcuch znakowy s inicjalizując go wszystkimi znakami łańcucha hello
    string s(hello.cbegin(),hello.cend());

    // zakresowa pętla for po wszystkich znakach
    for (char c : s) {
        cout << c;
    }
    cout << endl;

    // odwróć kolejność wszystkich znaków w łańcuchu
    reverse (s.begin(), s.end());
    cout << "odwrocona kolejnosc:       " << s << endl;

    // posortuj wszystkie znaki w łańcuchu
    sort (s.begin(), s.end());
    cout << "uporządkowane:       " << s << endl;

    // usuń sąsiadujące powtórzenia
    // - unique() zmienia porządek i zwraca nowy koniec łańcucha
    // - erase() odpowiednio zmniejsza łańcuch
    s.erase (unique(s.begin(),
                    s.end()),
             s.end());
    cout << "brak duplikatów: " << s << endl;
}
