/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <set>
#include <deque>
#include <algorithm>
#include <iterator>
#include <functional>
#include <iostream>
#include "print.hpp"
using namespace std;
using namespace std::placeholders;

int main()
{
    set<int,greater<int>> coll1 = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
    deque<int> coll2;

    // Uwaga: użyte kryterium sortowania greater<>() powoduje uporządkowanie odwrotne elementów:
    PRINT_ELEMENTS(coll1,"wartości początkowe: ");

    // przekształć wszystkie elementy do kolekcji coll2 jako iloczyny 10
    transform (coll1.cbegin(),coll1.cend(),    // źródło
               back_inserter(coll2),           // przeznaczenie
               bind(multiplies<int>(),_1,10)); // operacja
    PRINT_ELEMENTS(coll2,"po transformacji:    ");

    // zastąp elementy o wartości 70 elementami o wartości 42
    replace_if (coll2.begin(),coll2.end(),   // zakres
                bind(equal_to<int>(),_1,70), // kryterium zastąpienia
                42);                         // nowa wartość
    PRINT_ELEMENTS(coll2,"po zastąpieniu:      ");

    // usuń wszystkie elementy o wartościach pomiędzy 50 i 80
    coll2.erase(remove_if(coll2.begin(),coll2.end(),
                    bind(logical_and<bool>(),
                        bind(greater_equal<int>(),_1,50),
                        bind(less_equal<int>(),_1,80))),
                coll2.end());
    PRINT_ELEMENTS(coll2,"po usunięciu:        ");
}
