/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <vector>
#include <iostream>
using namespace std;

int main()
{
    // utwórz wektor z elementami od 1 do 6 w przypadkowej kolejności
    vector<int> coll = {2, 5, 4, 1, 6, 3};

    // znajdź i wypisz element o najmniejszej i największej wartości
    auto minpos = min_element (coll.cbegin(), coll.cend());
    cout << "min: " << *minpos << endl;
    auto maxpos = max_element (coll.cbegin(), coll.cend());
    cout << "max: " << *maxpos << endl;

    // posortuj wszystkie elementy
    sort (coll.begin(), coll.end());

    // znajdź pierwszy element o wartosci 3
    // - bez cbegin()/cend() bo później zmodyfikujemy element wskazywany przez pos3
    auto pos3 = find (coll.begin(), coll.end(),  // zakres
                      3);                        // wartość

    // odwróć kolejność elementów począwszy od znalezionego elementu o wartości 3 aż do końca
    reverse (pos3, coll.end());

    // wypisz wszystkie elementy
    for (auto elem : coll) {
        cout << elem << ' ';
    }
    cout << endl;
}
