/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <regex>
#include <string>

template <typename T>
std::string regexCode (T code)
{
    switch (code) {
        case std::regex_constants::error_collate:
            return "error_collate: "
                  "wyrażenie regularne ma nieprawidłową nazwę elementu porównania";
        case std::regex_constants::error_ctype:
            return "error_ctype: "
                  "wyrażenie regularne ma nieprawidłową nazwę klasy znaku";
        case std::regex_constants::error_escape:
            return "error_escape: "
                   "w wyrażeniu regularnym wystepuje nieprawidłowy znak lub znak ucieczki występuje na końcu wyrażenia";
        case std::regex_constants::error_backref:
            return "error_backref: "
                   "wyrażenie regularne ma nieprawidłowe odwołanie wsteczne";
        case std::regex_constants::error_brack:
            return "error_brack: "
                   "w wyrażeniu regularnym są niedopasowane nawiasy '[' i ']'";
        case std::regex_constants::error_paren:
            return "error_paren: "
                   "w wyrażeniu regularnym są niedopasowane nawiasy '(' i ')'";
        case std::regex_constants::error_brace:
            return "error_brace: "
                   "w wyrażeniu regularnym są niedopasowane nawiasy '{' i '}'";
        case std::regex_constants::error_badbrace:
            return "error_badbrace: "
                   "nieprawidłowy zakres w wyrażeniu {}";
        case std::regex_constants::error_range:
           return "error_range: "
                  "w wyrażeniu regularnym występuje nieprawidłowy zakres, na przykład '[b-a]'";
        case std::regex_constants::error_space:
           return "error_space: "
                  "brakuje pamięci, aby dokonać konwersji wyrażenia do skończonego stanu";
        case std::regex_constants::error_badrepeat:
            return "error_badrepeat: "
                   "jedno z podwyrażeń *?+{ nie zostało poprzedzone prawidłowym wyrażeniem regularnym";
        case std::regex_constants::error_complexity:
            return "error_complexity: "
                   "złożoność dopasowania z wykorzystaniem wyrażenia regularnego przekracza ustawiony poziom";
        case std::regex_constants::error_stack:
            return "error_stack: "
                   "brakuje pamięci, aby znaleźć dopasowanie do wyrażenia regularnego";
    }
    return "nieznany(niestandardowy) kod błędu przetwarzania wyrażeń regularnych";
}
