/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <regex>
#include <iostream>
using namespace std;

void out (bool b)
{
    cout << ( b ? "znaleziono" : "nie znaleziono") << endl;
}
int main()
{
    // wyszukanie wartości w zbiorze znaczników XML/HTML (z wykorzystaniem domyślnej składni):
    regex reg1("<.*>.*</.*>");
    bool found = regex_match ("<tag>value</tag>",                // dane
                              reg1);                             // wyrażenie regularne
    out(found);

    // wyszukanie wartości w zbiorze znaczników XML/HTML (znaczniki przed i za wartością muszą do siebie pasować):
    regex reg2("<(.*)>.*</\\1>");
    found = regex_match ("<tag>value</tag>",                     // dane
                         reg2);                                  // wyrażenie regularne
    out(found);

    // wyszukanie wartości w zbiorze znaczników XML/HTML (z wykorzystaniem składni grep):
    regex reg3("<\\(.*\\)>.*</\\1>",regex_constants::grep);
    found = regex_match ("<tag>value</tag>",                     // dane
                         reg3);                                  // wyrażenie regularne
    out(found);

    // wykorzystanie łańcucha C-string jako wyrażenia regularnego (potrzebne jawne rzutowanie na typ regex):
    found = regex_match ("<tag>value</tag>",                     // dane
                         regex("<(.*)>.*</\\1>"));               // wyrażenie regularne
    out(found);
    cout << endl;

    // regex_match() a regex_search():
    found = regex_match ("Znacznik XML: <tag>value</tag>",
                         regex("<(.*)>.*</\\1>"));               // nie pasuje
    out(found);
    found = regex_match ("Znacznik XML: <tag>value</tag>",
                         regex(".*<(.*)>.*</\\1>.*"));           // pasuje
    out(found);
    found = regex_search ("Znacznik XML: <tag>value</tag>",
                          regex("<(.*)>.*</\\1>"));              // pasuje
    out(found);
    found = regex_search ("Znacznik XML: <tag>value</tag>",
                          regex(".*<(.*)>.*</\\1>.*"));           // pasuje
    out(found);
}

