/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <vector>
#include <iostream>
using namespace std;

int main()
{
   vector<int> coll;

   // wstaw elementy od -3 do 9
   int i;
   for (i=-3; i<=9; ++i) {
       coll.push_back (i);
   }

   // wypisz liczbę elementów uzyskaną przez obliczenie odległości pomiędzy początkiem a końcem
   // - UWAGA: wykorzystuje operator - dla iteratorów
   cout << "liczba (odleglość): " << coll.end()-coll.begin() << endl;

   // wypisz wszystkie elementy
   // - UWAGA: wykorzystuje operator < zamiast operatora !=
   vector<int>::iterator pos;
   for (pos=coll.begin(); pos<coll.end(); ++pos) {
       cout << *pos << ' ';
   }
   cout << endl;

   // wypisz wszystkie elementy
   // - UWAGA: wykorzystuje operator [] zamiast operatora *
   for (i=0; i<coll.size(); ++i) {
       cout << coll.begin()[i] << ' ';
   }
   cout << endl;

   // wypisz co drugi element
   // - UWAGA: wykorzystuje operator +=
   for (pos = coll.begin(); pos < coll.end()-1; pos += 2) {
       cout << *pos << ' ';
   }
   cout << endl;
}
