/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <vector>
#include <iostream>
#include <string>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // utwórz pusty wektor na łańcuchy
    vector<string> sentence;

    // zarezerwuj pamięć na 5 elementów, aby uniknąć realokacji
    sentence.reserve(5);

    // dołacz kilka elementów
    sentence.push_back("Witaj,");
    sentence.insert(sentence.end(),{"jak","sie","masz","?"});

    // wypisz elementy rozdzielone spacjami
    copy (sentence.cbegin(), sentence.cend(),
          ostream_iterator<string>(cout," "));
    cout << endl;

    // wypisz 'dane techniczne'
    cout << "  max_size(): " << sentence.max_size() << endl;
    cout << "  size():     " << sentence.size()     << endl;
    cout << "  capacity(): " << sentence.capacity() << endl;

    // zamień drugi element z czwartym
    swap (sentence[1], sentence[3]);

    // przed elementem "?" wstaw element "zawsze"
    sentence.insert (find(sentence.begin(),sentence.end(),"?"),
                     "zawsze");

    // przypisz "!" do ostatniego elementu
    sentence.back() = "!";
    
    // wypisz elementy rozdzielone spacjami
    copy (sentence.cbegin(), sentence.cend(),
          ostream_iterator<string>(cout," "));
    cout << endl;

    // ponownie wypisz 'dane techniczne'
    cout << "  size():     " << sentence.size()     << endl;
    cout << "  capacity(): " << sentence.capacity() << endl;

    // usuń ostatnie dwa elementy
    sentence.pop_back();
    sentence.pop_back();
    // zmniejsz pojemność (od C++ 11)
    sentence.shrink_to_fit();

    // ponownie wypisz 'dane techniczne'
    cout << "  size():     " << sentence.size()     << endl;
    cout << "  capacity(): " << sentence.capacity() << endl;
}
