/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <condition_variable>
#include <mutex>
#include <future>
#include <iostream>

bool readyFlag; 
std::mutex readyMutex;
std::condition_variable readyCondVar;

void thread1()
{
    // wykonanie operacji, które wątek thread2 potrzebuje do przygotowania
    std::cout << "<return>" << std::endl;
    std::cin.get();
    // zasygnalizowanie, że wątek thread1 zrealizował działania przygotowawcze
    {
        std::lock_guard<std::mutex> lg(readyMutex);
        readyFlag = true;
    } // zwolnienie blokady
    readyCondVar.notify_one();
}
void thread2()
{
    // oczekiwanie, aż flaga gotowości będzie miała wartość true (readyFlag ma wartość true)
    {
        std::unique_lock<std::mutex> ul(readyMutex);
        readyCondVar.wait(ul, []{ return readyFlag; });
    } // zwolnienie blokady

    // wykonanie operacji, które powinny być wykonane po przygotowaniu działań przez wątek thread1
    std::cout << "zrobione" << std::endl;
}

int main()
{
    auto f1 = std::async(std::launch::async,thread1);
    auto f2 = std::async(std::launch::async,thread2);
}

