<?php
/*
	Plugin Name: WP-Cal
	Plugin URI: http://www.fahlstad.se
	Description: WordPress event calendar
	Author: Fredrik Fahlstad
	Version: 0.3
	Author URI: http://www.fahlstad.se
*/
$pluginpath = get_bloginfo('wpurl')."/wp-content/plugins/wp-cal/";

function cal($content){
	if(!preg_match('|<!--cal-->|', $content))
		return $content;
		
	$out .=  "<div id='cal'></div>";
	$out .=  "<div id='msg'></div>";
	$out .=  "<div id='calext'></div>";
	
	if(get_option('cal_is_private') == true){
		$out .= get_loginform();
		$out .=  "<div id='error'></div>";
		
	}
	else {
		$out .= "<script language='javascript'>cal_init();</script>";
	}
		

	return preg_replace('|<!--cal-->|',$out, $content);
}
function cal_head(){
	global $post, $pluginpath;
	if(preg_match('|<!--cal-->|', $post->post_content)){

		if(get_option('cal_where') == 'side'){ ?>
			<link rel="stylesheet" href="<?php echo $pluginpath.'functions/cal.css';?>" type="text/css" media="screen" title="no title" />
		<?php }
		else{ ?>
			<link rel="stylesheet" href="<?php echo $pluginpath.'functions/cal_noside.css';?>" type="text/css" media="screen" title="no title" />
		<?php }	?>
		
		<script src="<?php echo $pluginpath."js/prototype.js";?>" type="text/javascript" charset="utf-8"></script>
		<script src="<?php echo $pluginpath."js/scriptaculous.js";?>" type="text/javascript" charset="utf-8"></script>
		<script src="<?php echo $pluginpath."js/cal.js";?>" type="text/javascript" charset="utf-8"></script>
<?php }
}
function get_loginform(){
	return "
	<div id='calloginform'>
	<h4>This calendar is private</h4><br />
	
	<form method='post' action='' id = 'loginform' onsubmit='return login()'>
		Password: <br /><input type='password' id='pass' />
		<input type='submit' value='Send' />
	</form>
	</div>";
}
function cal_init() {
	if (function_exists('add_options_page')) 
	{
		add_options_page('wp-cal options', 'WP-Cal', 9, dirname(__FILE__).'/functions/options.php');
	}
}
function cal_install(){
	global $table_prefix, $wpdb, $user_level;
	
	$table = $table_prefix . "calevents";
	if ($user_level < 8)
	{
		return;
	}
	else{
		$sql = "CREATE TABLE IF NOT EXISTS `$table` (
		  `id` int(11) NOT NULL auto_increment,
		  `title` varchar(255) NOT NULL,
		  `description` text,
		  `date` varchar(30) NOT NULL default '',
		  `start_time` varchar(10) NOT NULL default '00:00',
		  `end_time` varchar(10) NOT NULL default '00:00',
		  PRIMARY KEY  (`id`)
		)";
		require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
		dbDelta($sql);
	}
}
// Hooks and filters
if (isset($_GET['activate']) && $_GET['activate'] == 'true')
{
	add_action('init', 'cal_install');
}
add_action('the_content', 'cal');
add_action('wp_head', 'cal_head');
add_action('admin_menu', 'cal_init');
