<?php


include( 'functions.php' );

// Gather variables from 
// user input and break them 
// down for usage in our script 
if(!isset($_GET['date'])){ 
   $date = mktime(0,0,0,date('m'), date('d'), date('Y')); 
} 
else { 
   $date = $_GET['date']; 
} 
$day = date('d', $date); 
$month = date('m', $date); 
$year = date('Y', $date); 


// Get the first day of the month 
$month_start = mktime(0,0,0,$month, 1, $year); 

// Get friendly month name 
$month_name = date('F', $month_start); 

// Figure out which day of the week 
// the month starts on. 
$month_start_day = date('D', $month_start); 

if(get_option('cal_week_start') == 'monday'){
	switch($month_start_day){ 
    case "Mon": $offset = 0; break; 
    case "Tue": $offset = 1; break; 
    case "Wed": $offset = 2; break; 
    case "Thu": $offset = 3; break; 
    case "Fri": $offset = 4; break; 
    case "Sat": $offset = 5; break; 
    case "Sun": $offset = 6; break; 

	}
} 
if(get_option('cal_week_start') == 'sunday'){
	switch($month_start_day){ 
		case "Sun": $offset = 0; break; 
    case "Mon": $offset = 1; break; 
    case "Tue": $offset = 2; break; 
    case "Wed": $offset = 3; break; 
    case "Thu": $offset = 4; break; 
    case "Fri": $offset = 5; break; 
    case "Sat": $offset = 6; break; 

	}
}

// determine how many days are in the last month. 
if($month == 1){ 
   $num_days_last = cal_days_in_month(0, 12, ($year -1)); 
} else { 
   $num_days_last = cal_days_in_month(0, ($month -1), $year); 
} 

// determine how many days are in the current month. 
$num_days_current = cal_days_in_month(0, $month, $year); 

// Build an array for the current days 
// in the month 
for($i = 1; $i <= $num_days_current; $i++){ 
    $num_days_array[] = $i; 
} 

// Build an array for the number of days 
// in last month 
for($i = 1; $i <= $num_days_last; $i++){ 
    $num_days_last_array[] = $i; 
} 

// If the $offset from the starting day of the 
// week happens to be Sunday, $offset would be 0, 
// so don't need an offset correction. 

if($offset > 0){ 
    $offset_correction = array_slice($num_days_last_array, -$offset, $offset); 
    $new_count = array_merge($offset_correction, $num_days_array);
    $offset_count = count($offset_correction); 
} 

// The else statement is to prevent building the $offset array. 
else { 
	$new_count = $num_days_array; 
} 

// count how many days we have with the two 
// previous arrays merged together 
$current_num = count($new_count);

// Since we will have 5 HTML table rows (TR) 
// with 7 table data entries (TD) 
// we need to fill in 35 TDs 
// so, we will have to figure out 
// how many days to appened to the end 
// of the final array to make it 35 days.
if($current_num > 35){ 
   $num_weeks = 6;
	 $outset = (42 - $current_num); 
} 
elseif($current_num < 35){
		$num_weeks = 5; 	
		$outset = (35 - $current_num); 
}
if($current_num == 35){ 
	$num_weeks = 5; 
	$outset = 0; 
}
// Outset Correction 
for($i = 1; $i <= $outset; $i++){ 
	$new_count[] = $i; 
}
// Now let's "chunk" the $new_count array 
// into weeks. Each week has 7 days 
// so we will array_chunk it into 7 days. 
$weeks = array_chunk($new_count, 7);

		
//$previous_link = "<a href=\"".$_SERVER['PHP_SELF']."?date="; 
if($month == 1){ 
   $d .= mktime(0,0,0,12,$day,($year -1)); 
} else { 
   $d .= mktime(0,0,0,($month -1),$day,$year); 
} 

$previous_link = "<a href='javascript:onclick=get_month($d)'"; 
$previous_link .= "\"><< Prev</a>"; 

//$next_link = "<a href=\"".$_SERVER['PHP_SELF']."?date="; 
if($month == 12){ 
   $n .= mktime(0,0,0,1,$day,($year + 1)); 
} else { 
   $n .= mktime(0,0,0,($month +1),$day,$year); 
} 

$next_link = "<a href='javascript:onclick=get_month($n)'"; 
$next_link .= "\">Next >></a>"; 

  // Build the heading portion of the calendar table 
echo "<table class='calendar' cellspacing='0' cellpadding='0'>\n". 
     	"<tr>\n". 
     		"<td colspan='7'>". 
     			"<table align='center' class='calnav'>". 
     				"<tr>". 
     					"<td colspan='2' align='left'>$previous_link</td>\n". 
     					"<td colspan='3' align='center'><h3>$month_name $year</h3></td>\n". 
     					"<td colspan='2' align='right'>$next_link</td>\n". 
     				"</tr>\n". 
     			"</table>\n". 
     		"</td>\n". 
     "<tr>\n";

// Starts on monday
if(get_option('cal_week_start') == 'monday')
	echo "<th>Mon</th><th>Tue</t><th>Wed</th><th>Thu</th><th>Fri</th><th>Sat</th><th>Sun</th>\n"; 
// Starts on sunday
if(get_option('cal_week_start') == 'sunday')
	echo "<th>Sun</th><th>Mon</th><th>Tue</th><th>Wed</th><th>Thu</th><th>Fri</th><th>Sat</th>\n"; 

     echo "</tr>\n"; 

// Now we break each key of the array  
// into a week and create a new table row for each 
// week with the days of that week in the table data 

$i = 0; 
$now = mktime(0,0,0,date('m'), date('d'), date('Y'));

foreach($weeks AS $week){ 
	
	echo "<tr>\n"; 
	
	foreach($week as $d){ 
		
		$mydate = mktime(0,0,0,$month,$d,$year);
		
		if($i < $offset_count)
			echo "<td></td>";
			
		elseif($i >= ($num_weeks * 7) - $outset)  
			echo "<td></td>";
		
		else { 
			$class = "days";
			$day_link = "<a href='javascript:onclick=get_day($mydate)'>$d</a>";
		
			if($mydate == $now)
				$class .= " today";
						
				echo "<td class='$class' valign='top'>$day_link".day_events($mydate)."</td>\n"; 
				
			} 
		$i++;
	} 
	echo "</tr>\n";    
} 

// Close out your table and that's it! 
echo '</table>'; 

/*echo "<pre>";
print_r($ev);
echo "</pre>";*/
?> 




