# Rozdział 15. - Przykłady

Przykłady do rozdziału 15. pt. *Pliki i strumienie* książki *C# 8.0 Programowanie*.

## Klasa Stream

* [Listing 1. Najważniejsze składowe klasy Stream](PlikiIStrumienie/Streams/Program.cs#L38-L40)
* [Listing 2. Odczyt zadanej liczby bajtów](PlikiIStrumienie/Streams/Program.cs#L12-L32)
* [Listing 3. Metoda Seek](PlikiIStrumienie/Streams/Program.cs#L42)

## Typy operujące na tekstach

* [Listing 4. Metody klasy TextReader odczytujące bloki znaków](PlikiIStrumienie/Text/Program.cs#L39-L40)
* [Listing 5. Zapis tekstu do pliku przy użyciu klasy StreamWriter](PlikiIStrumienie/Text/Program.cs#L12-L15)
* [Listing 6. Opakowanie łańcucha znaków przez obiekt StringReader](PlikiIStrumienie/Text/Program.cs#L17-L26)
* [Listing 7. Przechwytywanie strumienia wyjściowego konsoli przy użyciu obiektu StreamWriter](../Rozdzial01/HelloWorldPassingTests/HelloWorld.Tests/WhenProgramRuns.cs#L14-L15)
* [Listing 8. Zapis tekstu przy użyciu strony kodowej Windows 1252](PlikiIStrumienie/Text/Program.cs#L28-L32)

## Pliki i katalogi

* [Listing 9. Konstruktory klasy FileStream umożliwiające podanie ścieżki dostępu do pliku](PlikiIStrumienie/FilesAndDirectories/Program.cs#L41-L50)
* [Listing 10. Porównanie metody File.Create oraz konstruktora klasy FileStream](PlikiIStrumienie/FilesAndDirectories/Program.cs#L10-L18)
* [Listing 11. Dodawanie tekstu do pliku przy użyciu klasy StreamWriter](PlikiIStrumienie/FilesAndDirectories/Append.cs#L9-L15)
* [Listing 12. Tworzenie obiektu StreamWriter w trybie dopisywania przy użyciu metody File.AppendText](PlikiIStrumienie/FilesAndDirectories/Append.cs#L20-L26)
* [Listing 13. Dopisywanie jednego łańcucha znaków do pliku](PlikiIStrumienie/FilesAndDirectories/Append.cs#L31-L34)
* [Listing 14. Dodawanie do pliku jednego wiesza tekstu](PlikiIStrumienie/FilesAndDirectories/Append.cs#L39-L42)
* [Listing 15. Rekurencyjne poszukiwanie plików określonego typu](PlikiIStrumienie/FilesAndDirectories/Program.cs#L20-L25)
* [Listing 16. Wyświetlanie informacji o pliku przy użyciu obiektu FileInfo](PlikiIStrumienie/FilesAndDirectories/Program.cs#L27-L29)
* [Listing 17. Określanie, gdzie należy zapisać ustawienia](PlikiIStrumienie/FilesAndDirectories/Program.cs#L31-L34)

## Serializacja

* [Listing 18. Typ danych umożliwiający serializację](PlikiIStrumienie/Serialization/Person.cs)
* [Listing 19. Serializacja przy użyciu klasy BinaryFormatter](PlikiIStrumienie/Serialization/UsingBinaryFormatter.cs#L10-L12)
* [Listing 20. Deserializacja przy użyciu klasy BinaryFormatter](PlikiIStrumienie/Serialization/UsingBinaryFormatter.cs#L19-L21)
* [Listing 21. Prosty model obiektowy umożliwiający użycie biblioteki JSON.NET](PlikiIStrumienie/Serialization/JsonDotNet.cs#L59-L72)
* [Listing 22. Serializacja danych przy użyciu klasy JsonConverter](PlikiIStrumienie/Serialization/JsonDotNet.cs#L13-L31)
* [Listing 23. Deserializacja danych przy użyciu klasy JsonConvert](PlikiIStrumienie/Serialization/JsonDotNet.cs#L33)
* [Listing 24. Kontrola postaci danych JSON przy użyciu atrybutu JsonProperty](PlikiIStrumienie/Serialization/WithAttributes.cs#L7-L17)
* [Listing 25. Odczytywanie danych JSON przy użyciu JToken](PlikiIStrumienie/Serialization/JsonDotNet.cs#L35-L44)
* [Listing 26. Operowanie na danych przy użyciu LINQ to JSON](PlikiIStrumienie/Serialization/JsonDotNet.cs#L46-L48)
* [Listing 27. Zapytanie operujące na danych w formacie JSON](PlikiIStrumienie/Serialization/JsonDotNet.cs#L50-L56)
