﻿using System;

namespace Deconstruction
{
    class Program
    {
        static void Main()
        {
            var s = new Size(10, 20);
            Console.WriteLine(DiagonalLength(s));
            Console.WriteLine(DescribeSize(s));
            Console.WriteLine(Describe(s));
        }

        static double DiagonalLength(Size s)
        {
            (double w, double h) = s;
            return Math.Sqrt(w * w + h * h);
        }

        static string DescribeSize(Size s) => s switch
        {
            (0, 0) => "pusty",
            (0, _) => "bardzo krótki",
            (double w, 0) => $"bardzo wąski, o długości: {w}",
            _ => "normalny"
        };

        static string Describe(object o) => o switch
        {
            Size(0, 0) => "pusty",
            Size(0, _) => "bardzo krótki",
            Size(double w, 0) => $"bardzo wąski, o długości: {w}",
            Size _ => "normalny kształt",
            _ => "brak kształtu"
        };
    }
}
