﻿using System;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace Tpl
{
    class Program
    {
        static async Task Main()
        {
            var w = new HttpClient();
            string url = "https://helion.pl/";
            Task<string> webGetTask = w.GetStringAsync(url);

            string pageContent = await webGetTask;

#pragma warning disable CS4014 // W tym przykładzie niczego nie robimy ze zwróconym zadaniem, jednak w przypadku metody asynchronicznej kompilatorowi nie podoba się to. Normalnie, w metodzie asynchronicznej używamy wait zamiast metody ContinueWith
            webGetTask.ContinueWith(t =>
            {
                string webContent = t.Result;
                Console.WriteLine("Długość strony WWW wynosi: " + webContent.Length);
            });
#pragma warning restore CS4014
        }

        private static void ShowContinuations()
        {
            Task op = Task.Run(DoSomething);
            var cs = new CancellationTokenSource();
            Task onDone = op.ContinueWith(
                _ => Console.WriteLine("To nigdy nie zosatnie wykonane"),
                cs.Token);
            Task andAnotherThing = onDone.ContinueWith(
                _ => Console.WriteLine("Kontynuacja kontynuacji"));
            cs.Cancel();
        }

        static void DoSomething()
        {
            Thread.Sleep(1000);
            Console.WriteLine("Zakończono zadanie początkowe");
        }
    }

    // Ten przykład służy do celów demonstracyjnych i nie uda się go skompilować; stąd użycie dyrektywy #if false
#if false
public virtual IAsyncResult BeginWrite(byte[] buffer, int offset, int count,
    AsyncCallback callback, object state) ...
public virtual void EndWrite(IAsyncResult asyncResult) ...

public abstract void Write(byte[] buffer, int offset, int count) ...
#endif
}