﻿using System;
using System.IO;
using System.Linq;
using System.Reflection;

namespace CustomAttributes
{
    class Program
    {
        static void Main()
        {
            ShowPluginInformation(Path.GetDirectoryName(typeof(Program).Assembly.Location));
            
            
            // Uwaga: przykład działa tylko w .NET Framework. Aby go wypróbować, należy zmienieć platformę
            // docelową projektu na .NET Framework. 
            // ShowPluginInformationReflectionOnlyContext(new FileInfo(typeof(Program).Assembly.Location));
        }

        static void ShowPluginInformation(string pluginFolder)
        {
            var dir = new DirectoryInfo(pluginFolder);
            foreach (var file in dir.GetFiles("*.dll"))
            {
                Assembly pluginAssembly = Assembly.LoadFrom(file.FullName);
                var plugins =
                     from type in pluginAssembly.ExportedTypes
                     let info = type.GetCustomAttribute<PluginInformationAttribute>()
                     where info != null
                     select new { type, info };

                foreach (var plugin in plugins)
                {
                    Console.WriteLine($"Typ wtyczki: {plugin.type.Name}");
                    Console.WriteLine(
                        $"Nazwa: {plugin.info.Name}, autor {plugin.info.Author}");
                    Console.WriteLine($"Opis: {plugin.info.Description}");
                }
            }
        }

        static void ShowPluginInformationReflectionOnlyContext(FileInfo file)
        {
            Type pluginAttributeType = typeof(PluginInformationAttribute);

            Assembly pluginAssembly = Assembly.ReflectionOnlyLoadFrom(file.FullName);
            var plugins =
                 from type in pluginAssembly.ExportedTypes
                 let info = type.GetCustomAttributesData().SingleOrDefault(
                                attrData => attrData.AttributeType.FullName == pluginAttributeType.FullName)
                 where info != null
                 let description = info.NamedArguments
                                       .SingleOrDefault(a => a.MemberName == "Description") 
                 select new
                 {
                     type,
                     Name = (string)info.ConstructorArguments[0].Value,
                     Author = (string)info.ConstructorArguments[1].Value,
                     Description =
                         description == null ? null : description.TypedValue.Value
                 };

            foreach (var plugin in plugins)
            {
                Console.WriteLine($"Typ wtyczki: {plugin.type.Name}");
                Console.WriteLine($"Nazwa: {plugin.Name}, autor {plugin.Author}");
                Console.WriteLine($"Opis: {plugin.Description}");
            }
        }
    }

    // Ten typ jest zdefiniowany w bibliotece .NET. W książce przedstawiłem go jedynie w celach demonstracyjnych,
    // stąd użycie #if false
#if false
    public interface ICustomAttributeProvider
    {
        object[] GetCustomAttributes(bool inherit);
        object[] GetCustomAttributes(Type attributeType, bool inherit);
        bool IsDefined(Type attributeType, bool inherit);
    }
#endif
}
