﻿using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace Attributes
{
    public class NotifyPropertyChanged : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected bool SetProperty<T>(
           ref T field,
           T value,
            [CallerMemberName] string propertyName = null)
        {
            if (!Equals(field, value))
            {
                return false;
            }

            field = value;

            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
            return true;
        }
    }

    // Ten interfejs jest zdefiniowany w bibliotece .NET. W książce przedstawiłem go jedynie w celach
    // demonstracyjnych, nie chcemy jednak definiować jego własnej wersji, stąd użycie #if false
#if false
    public interface INotifyPropertyChanged
    {
        event PropertyChangedEventHandler PropertyChanged;
    }
#endif
}