# Rozdział 10. - Przykłady

Przykłady do rozdziału 10. pt. *LINQ* książki *C# 8.0 Programowanie*.

## Wyrażenia zapytań

* [Listing 1. Wyrażenie zapytania LINQ](Linq/QueryExpressions/Program.cs#L16-L24)
* [Listing 2. Analogiczny kod, który nie korzysta z LINQ](Linq/QueryExpressions/Program.cs#L29-L36)
* [Listing 3. Zapytanie pobierające wartość jednej właściwości](Linq/QueryExpressions/Program.cs#L41-L49)
* [Listing 4. Efekt konwersji wyrażenia zapytania](Linq/QueryExpressions/Program.cs#L54-L57)
* [Listing 5. Sposób rozwijania trywialnych klauzul select](Linq/QueryExpressions/Program.cs#L62-L64)
* [Listing 6. Zapytanie z klauzulą let](Linq/QueryExpressions/Program.cs#L69-L73)
* [Listing 7. Sposób (przybliżony) rozwijania wyrażeń zapytań z wieloma zmiennymi zakresu](Linq/QueryExpressions/Program.cs#L78-L82)
* [Listing 8. Całkowicie bezsensowne metody Where oraz Select](Linq/QueryExpressions/SillyLinqProvider.cs#L5-L18)
* [Listing 9. Bezsensowne zapytanie](Linq/QueryExpressions/Program.cs#L87-L89)
* [Listing 10. Sposób, w jaki kompilator przekształcił nasze bezsensowne zapytanie](Linq/QueryExpressions/Program.cs#L94)
* [Listing 11. Niestandardowy dostawca LINQ dla danych typu CultureInfo[]](Linq/CustomLinqExample/Program.cs)

## Przetwarzanie opóźnione

* [Listing 12. Zapytanie, dla którego źródłem danych jest sekwencja nieskończona](Linq/QueryInifiniteSource/Program.cs)
* [Listing 13. Niestandardowy operator Where o opóźnionym działaniu](Linq/QueryInifiniteSource/CustomDeferredLinqProvider.cs#L6-L19)
* [Listing 14. Niezamierzone, wielokrotne przetwarzanie zapytania opóźnionego](Linq/QueryExpressions/Program.cs#L99-L113)

## LINQ, typy ogólne oraz interfejs IQueryable&lt;T&gt;

* [Listing 15. Interfejsy IQueryable oraz IQueryable&lt;T&gt;](Linq/QueryExpressions/Program.cs#L119-L136)
* [Listing 16. Metody Where dla typów IEnumerable&lt;T&gt; oraz IQueryable&lt;T&gt;](Linq/QueryExpressions/Program.cs#L138-L152)

## Standardowe operatory LINQ

* [Listing 17. Proste źródło danych dla zapytań LINQ](Linq/StandardOperators/Course.cs#L5-L56)

### Filtrowanie

* [Listing 18. Operator Where z indeksem](Linq/StandardOperators/Filtering.cs#L11-L12)
* [Listing 19. Operator OfType&lt;T&gt;](Linq/StandardOperators/Filtering.cs#L15-L21)

### Selekcja

* [Listing 20. Operator Select z indeksem](Linq/StandardOperators/Projection.cs#L11-L12)
* [Listing 21. Wersja operatora Select z indeksem operująca na wynikach operatora Where](Linq/StandardOperators/Projection.cs#L17-L19)
* [Listing 22. Użycie operatora Select z indeksem przed operatorem Where](Linq/StandardOperators/Projection.cs#L24-L27)
* [Listing 23. Pobieranie większej ilości danych niż to konieczne](Linq/StandardOperators/Projection.cs#L34-L40)
* [Listing 24. Klauzula Select korzystająca z typu anonimowego](Linq/StandardOperators/Projection.cs#L47-L49)
* [Listing 25. Stosowanie operatora Select do przekształcania liczb](Linq/StandardOperators/Projection.cs#L58-L62)

### Operator SelectMany

* [Listing 26. Stosowanie operatora SelectMany w wyrażeniu zapytania](Linq/StandardOperators/Projection.cs#L67-L76)
* [Listing 27. Operator SelectMany](Linq/StandardOperators/Projection.cs#L84-L86)
* [Listing 28. Spłaszczanie tablicy nieregularnej](Linq/StandardOperators/Projection.cs#L91-L102)
* [Listing 29. Wersja metody SelectMany, która nie korzysta z projekcji elementów](Linq/StandardOperators/Projection.cs#L116)
* [Listing 30. Jedna z implementacji metody SelectMany](Linq/StandardOperators/Projection.cs#L119-L130)

### Określanie porządku

* [Listing 31. Wyrażenie zapytania z klauzulą orderby](Linq/StandardOperators/Ordering.cs#L9-L11)
* [Listing 32. Jak nie używać wielu kryteriów sortowania](Linq/StandardOperators/Ordering.cs#L16-L19)
* [Listing 33. Wyrażenie zapytania wykorzystujące kilka kryteriów sortowania](Linq/StandardOperators/Ordering.cs#L24-L26)
* [Listing 34. Dwa kryteria sortowania określane w formie wywołań operatorów LINQ](Linq/StandardOperators/Ordering.cs#L31-L33)

### Konkretne elementy i podzakresy

* [Listing 35. Zastosowanie operatora Single](Linq/StandardOperators/Subranges.cs#L10-L14)
* [Listing 36. Operator Single z predykatem](Linq/StandardOperators/Subranges.cs#L19-L20)
* [Listing 37. Użycie operatora First w celu pobrania najdłuższego kursu](Linq/StandardOperators/Subranges.cs#L25-L28)
* [Listing 38. Jak nie należy używać operatora ElementAt](Linq/StandardOperators/Subranges.cs#L33-L39)

### Agregacja

* [Listing 39. Operator Average wykorzystujący projekcję](Linq/StandardOperators/Aggregation.cs#L14-L15)
* [Listing 40. Operator Max korzystający z projekcji](Linq/StandardOperators/Aggregation.cs#L20)
* [Listing 41. Użycie operatora Sum oraz Aggregate o analogicznym znaczeniu](Linq/StandardOperators/Aggregation.cs#L25-L27)
* [Listing 42. Implementacja operatora Max przy użyciu operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L32-L34)
* [Listing 43. Implementacja średniej przy użyciu operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L39-L48)
* [Listing 44. Użycie operatora Aggregate do wyliczenia prostokąta opisującego inne prostokąty](Linq/StandardOperators/Aggregation.cs#L51-L52)
* [Listing 45. Nieco bardziej rozbudowany i mniej tajemniczy sposób wyznaczania prostokąta opisującego](Linq/StandardOperators/Aggregation.cs#L56-L60)
* [Listing 46. Efekt działania operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L70)

### Operacje na zbiorach

* [Listing 47. Usuwanie duplikatów przy użyciu operatora Distinct](Linq/StandardOperators/SetOperations.cs#L9)

### Operatory działające na całych sekwencjach z zachowaniem kolejności

* [Listing 48. Łączenie list przy użyciu operatora Zip](Linq/StandardOperators/WholeSequenceOrderPreserving.cs#L11-L18)

### Grupowanie

* [Listing 49. Grupujące wyrażenie zapytania](Linq/StandardOperators/Grouping.cs#L11-L24)
* [Listing 50. Rozwinięcie prostego zapytania grupującego](Linq/StandardOperators/Grouping.cs#L29)
* [Listing 51. Zapytanie grupujące z projekcją elementów](Linq/StandardOperators/Grouping.cs#L34-L35)
* [Listing 52. Rozwinięcie wyrażenia zapytania wykorzystującego projekcję elementów](Linq/StandardOperators/Grouping.cs#L40-L41)
* [Listing 53. Zapytanie grupujące z projekcją grup](Linq/StandardOperators/Grouping.cs#L46-L49)
* [Listing 54. Rozwinięte zapytanie grupujące z projekcją grup](Linq/StandardOperators/Grouping.cs#L54-L57)
* [Listing 55. Operator GroupBy wykorzystujący projekcje kluczy i grup](Linq/StandardOperators/Grouping.cs#L62-L65)
* [Listing 56. Operator GroupBy wykorzystujący projekcję kluczy, elementów oraz grup](Linq/StandardOperators/Grouping.cs#L70-L75)
* [Listing 57. Złożony klucz grupowania](Linq/StandardOperators/Grouping.cs#L80-L90)

### Złączenia

* [Listing 58. Klasa łącząca studenta z kursem](Linq/StandardOperators/CourseChoice.cs#L3-L10)
* [Listing 59. Zapytanie z klauzulą join](Linq/StandardOperators/Joins.cs#L19-L38)
* [Listing 60. Bezpośrednie wykorzystanie operatora Join](Linq/StandardOperators/Joins.cs#L43-L47)
* [Listing 61. Pogrupowane złączenie](Linq/StandardOperators/Joins.cs#L52-L64)
* [Listing 62. Operator GroupJoin](Linq/StandardOperators/Joins.cs#L69-L73)

### Konwersje

* [Listing 63. Jak nie należy rzutować sekwencji](Linq/StandardOperators/Conversion.cs#L11-L12)
* [Listing 64. Jak należy rzutować sekwencje](Linq/StandardOperators/Conversion.cs#L19)
* [Listing 65. Tworzenie kolekcji asocjacyjnej](Linq/StandardOperators/Conversion.cs#L24-L29)
