# Rozdział 5. - Przykłady

Przykłady do rozdziału 5. pt. *Kolekcje* książki *C# 8.0 Programowanie*.

## Tablice

* [Listing 1. Tworzenie tablic](Kolekcje/Arrays/Program.cs#L10-L11)
* [Listing 2. Odwoływanie się do elementów tablic](Kolekcje/Arrays/Program.cs#L13-L17)
* [Listing 3. Złożone odwołania do tablic](Kolekcje/Arrays/Program.cs#L23-L29)
* [Listing 4. Jak nie należy modyfikować tablicy o elementach typu niezmiennego](Kolekcje/Arrays/Program.cs#L36-L39)
* [Listing 5. Modyfikacja tablic o elementach typu niezmiennego](Kolekcje/Arrays/Program.cs#L19-L20)
* [Listing 6. Pracochłonny sposób inicjalizacji tablic](Kolekcje/Arrays/ArrayInitialization.cs#L7-L12)
* [Listing 7. Składnia inicjalizatora tablic](Kolekcje/Arrays/ArrayInitialization.cs#L17-L18)
* [Listing 8. Skrócona składnia inicjalizatora tablic](Kolekcje/Arrays/ArrayInitialization.cs#L23-L24)
* [Listing 9. Składnia inicjalizatora tablic wykorzystująca automatyczne określanie typu](Kolekcje/Arrays/ArrayInitialization.cs#L29-L30)
* [Listing 10. Tablice jako argumenty](Kolekcje/Arrays/ArrayInitialization.cs#L35)
* [Listing 11. Przeszukiwanie tablicy przy użyciu metody IndexOf](Kolekcje/Arrays/Searching.cs#L10-L18)
* [Listing 12. Przeszukiwanie tablicy przy użyciu metody FindIndex](Kolekcje/Arrays/Searching.cs#L21-L24)
* [Listing 13. Zastosowanie wyrażenia lambda w metodzie FindIndex](Kolekcje/Arrays/Searching.cs#L28-L29)
* [Listing 14. Odnajdywanie wielu wartości przy użyciu metody FindAll](Kolekcje/Arrays/Searching.cs#L32-L33)
* [Listing 15. Wydajność wyszukiwania oraz metoda BinarySearch](Kolekcje/Arrays/Searching.cs#L37-L82)
* [Listing 16. Tworzenie tablicy nieregularnej](Kolekcje/Arrays/ArrayInitialization.cs#L40-L47)
* [Listing 17. Tablice prostokątne](Kolekcje/Arrays/ArrayInitialization.cs#L52-L58)
* [Listing 18. Sześcienna „prostokątna” tablica o wymiarach 2 na 3 na 5](Kolekcje/Arrays/ArrayInitialization.cs#L60-L72)

## List&lt;T&gt;

* [Listing 19. Stosowanie list typu List&lt;T&gt;](Kolekcje/ListsAndSequences/Program.cs#L10-L22)
* [Listing 20. Inicjalizacja list](Kolekcje/ListsAndSequences/Program.cs#L30)

## Interfejsy list i sekwencji

* [Listing 21. Interfejsy IEnumerable&lt;T&gt; oraz IEnumerable](Kolekcje/ListsAndSequences/Program.cs#L38-L46)
* [Listing 22. Interfejsy IEnumerator&lt;T&gt; oraz IEnumerator](Kolekcje/ListsAndSequences/Program.cs#L48-L58)
* [Listing 23. Interfejsy IAsyncEnumerable&lt;T&gt; oraz IAsyncEnumerator&lt;T&gt;](Kolekcje/ListsAndSequences/Program.cs#L60-L71)
* [Listing 24. Interfejs ICollection&lt;T&gt;](Kolekcje/ListsAndSequences/Program.cs#L73-L83)
* [Listing 25. Interfejs IList&lt;T&gt;](Kolekcje/ListsAndSequences/Program.cs#L85-L92)
* [Listing 26. Próba (nieudana) powiększenia tablicy](Kolekcje/ListsAndSequences/Program.cs#L24-L25)

## Implementacja list i sekwencji

* [Listing 27. Prosty iterator](Kolekcje/ImplementingSequences/Program.cs#L9-L23)
* [Listing 28. Bardzo prosty iterator](Kolekcje/ImplementingSequences/Program.cs#L25-L30)
* [Listing 29. Nieskończony iterator](Kolekcje/ImplementingSequences/Program.cs#L32-L44)
* [Listing 30. Samodzielna implementacja interfejsu IEnumerable&lt;T&gt;](Kolekcje/ImplementingSequences/FibonacciEnumerable.cs#L7-L47)
* [Listing 31. Weryfikacja argumentów iteratora](Kolekcje/ImplementingSequences/ArgumentValidation.cs#L9-L30)

## Odwołania do elementów z użyciem indeksów i zakresów

* [Listing 32. Odwołanie do ostatniego elementu tablicy wyrażające położenie względem jej końca](Kolekcje/RangeAndIndex/Program.cs#L9-L10)
* [Listing 33. Pobieranie fragmenty tablicy przy wykorzystaniu operatora zakresu](Kolekcje/RangeAndIndex/Program.cs#L12-L14)
* [Listing 34. Indeksy określające położenie względem początku oraz względem końca](Kolekcje/RangeAndIndex/Program.cs#L16-L24)
* [Listing 35. Indeksowanie względem końca i rozwiązania wcześniejsze](Kolekcje/RangeAndIndex/Program.cs#L26-L30)
* [Listing 36. Różne zakresy](Kolekcje/RangeAndIndex/Program.cs#L32-L48)
* [Listing 37. Pobieranie fragmentu łańcucha przy użyciu zakresu](Kolekcje/RangeAndIndex/Program.cs#L50-L52)
* [Listing 38. Pobieranie fragmentu ArraySegment&lt;T&gt; przy użyciu operatora zakresu](Kolekcje/RangeAndIndex/Program.cs#L68-L70)
* [Listing 39. Pobieranie fragmentu przy użyciu typu Span&lt;T&gt; i operatora zakresu](Kolekcje/RangeAndIndex/Program.cs#L75-L79)
* [Listing 40. Minimalistyczna obsługa indeksów](Kolekcje/RangeAndIndex/Indexable.cs#L3-L8)
* [Listing 41. Minimalistyczne rozwiązanie pozwalające na stosowanie zakresów](Kolekcje/RangeAndIndex/Rangeable.cs#L3-L8)
* [Listing 42. Jak są przekształcane indeksy zakresów](Kolekcje/RangeAndIndex/Program.cs#L54-L63)

## Słowniki

* [Listing 43. Zastosowanie słownika jako elementu pamięci podręcznej](Kolekcje/Dictionaries/UserCache.cs#L7-L38)
* [Listing 44. Pobieranie danych ze słownika przy użyciu indeksatora](Kolekcje/Dictionaries/AnotherCache.cs#L12)
* [Listing 45. Składnia inicjalizatora słownika](Kolekcje/Dictionaries/Initializers.cs#L9-L14)
* [Listing 46. Składnia inicjalizatora obiektu zastosowana podczas tworzenia słownika](Kolekcje/Dictionaries/Initializers.cs#L19-#L24)
* [Listing 47. Słownik, w którym nie jest uwzględniana wielkość liter](Kolekcje/Dictionaries/Program.cs#L15-L21)

## Zbiory

* [Listing 48. Zastosowanie zbioru do wykrywania powtarzających się elementów](Kolekcje/Sets/Program.cs#L13-L23)

## Kolekcje niezmienne

* [Listing 49. Tworzenie niezmiennego słownika](Kolekcje/ImmutableCollections/Program.cs#L15-L18)
* [Listing 50. Tworzenie niezmiennego słownika z użyciem obiektu budowniczego](Kolekcje/ImmutableCollections/Program.cs#L25-L30)
