# Rozdział 4. - Przykłady

Przykłady do rozdziału 4. pt. *Typy ogólne* książki *C# 8.0 Programowanie*.

## Typy ogólne

* [Listing 1. Definiowanie klasy ogólnej](TypyOgolne/GenericTypes/NamedContainer.cs#L3-L13)
* [Listing 2. Stosowanie klasy ogólnej](TypyOgolne/GenericTypes/Program.cs#L10-L12)
* [Listing 3. Skonstruowane typy ogólne zastosowane jako argumenty typu](TypyOgolne/GenericTypes/Program.cs#L14-L16)

## Ograniczenia

* [Listing 4. Tworzenie nowej instancji typu parametrycznego](TypyOgolne/Constraints/Deferred.cs#L3-L21)
* [Listing 5. Stosowanie ograniczeń typu](TypyOgolne/Constraints/GenericComparer.cs#L6-L13)
* [Listing 6. Tego kodu nie można skompilować: interfejs nie został zaimplementowany](TypyOgolne/Constraints/GenericComparer.cs#L19-L25)
* [Listing 7. Tego kodu nie można skompilować: brak ograniczenia](TypyOgolne/Constraints/GenericComparer.cs#L27-L33)
* [Listing 8. Ograniczenie określające, że jeden argument ma być typem pochodnym drugiego](TypyOgolne/Constraints/Foo.cs#L3-L4)
* [Listing 9. Ograniczenie wymagające typu referencyjnego](TypyOgolne/Constraints/Bar.cs#L3-L4)
* [Listing 10. Ograniczenie narzucone przez inne ograniczenie](TypyOgolne/Constraints/TestBase.cs#L3-L19)
* [Listing 11. Ograniczenie wymuszające użycie typu wartościowego](TypyOgolne/Constraints/Quux.cs#L3-L4)
* [Listing 12. Ograniczenia wymagające typu delegatu i typu wyliczeniowego](TypyOgolne/Constraints/DelegateAndEnumConstraints.cs#L5-L13)
* [Listing 13. Stosowanie wielu ograniczeń](TypyOgolne/Constraints/Spong.cs#L6-L7)

## Wartości przypominające zero

* [Listing 14. Pobieranie wartości domyślnej argumentu typu](TypyOgolne/ZeroLike/Program.cs#L13-L16)
* [Listing 15. Pobieranie domyślnej (zerowej) wartości wywnioskowanego typu](TypyOgolne/ZeroLike/Program.cs#L18)

## Metody ogólne

* [Listing 16. Metoda ogólna](TypyOgolne/GenericMethods/Program.cs#L25)
* [Listing 17. Wywoływanie metody ogólnej](TypyOgolne/GenericMethods/Program.cs#L10-L11)
* [Listing 18. Metoda ogólna ze zdefiniowanymi ograniczeniami](TypyOgolne/GenericMethods/Program.cs#L27-L31)
* [Listing 19. Wnioskowanie argumentu typu metody ogólnej](TypyOgolne/GenericMethods/Program.cs#L19-L20)

## Typy ogólne i krotki

* [Listing 20. Deklarowanie zmiennej krotki w standardowy sposób](TypyOgolne/GenericsAndTuples/Program.cs#L9)
* [Listing 21. Deklarowanie zmiennej krotki przy użyciu jej faktycznego typu](TypyOgolne/GenericsAndTuples/Program.cs#L11)
* [Listing 22. Zwracanie krotki](TypyOgolne/GenericsAndTuples/Program.cs#L18)

## Tajniki typów ogólnych

* [Listing 23. Jedna z możliwości szablonów, której nie można odtworzyć w typach ogólnych C#](TypyOgolne/GenericMethods/Program.cs#L36-L39)
