﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter18.Listing18_20
{
    using System;
    using System.Threading;
    using System.Threading.Tasks;

    public class Program
    {
        public static void Main()
        {
            DisplayStatus("Przed");
            Task taskA =
                Task.Run(() =>
                     DisplayStatus("Rozpoczynanie pracy..."))
                .ContinueWith(antecedent =>
                     DisplayStatus("Kontynuacja dla zadania A..."));
            Task taskB = taskA.ContinueWith(antecedent =>
          DisplayStatus("Kontynuacja dla zadania B..."));
            Task taskC = taskA.ContinueWith(antecedent =>
                DisplayStatus("Kontynuacja dla zadania C..."));
            Task.WaitAll(taskB, taskC);
            DisplayStatus("Ukończono!");
        }

        private static void DisplayStatus(string message)
        {
            string text = 
                    $@"{ Thread.CurrentThread.ManagedThreadId 
                        }: { message }";


            Console.WriteLine(text);
        }
    }
}





