namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_16
{
    using System.Collections.Generic;
    using Listing16_14;

    public class BinaryTree<T> :
      IEnumerable<T>
    {
        public BinaryTree(T value)
        {
            Value = value;
        }

        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            // Zwracanie elementu z danego wza.
            yield return Value;

            // Iterowanie po kadym elemencie z pary.
            foreach (BinaryTree<T> tree in SubItems)
            {
                if(tree != null)
                {
                    // Poniewa kady element z pary to drzewo,
                    // naley przej po tym drzewie i zwrci kady element.
                    foreach (T item in tree)
                    {
                        yield return item;
                    }
                }
            }
        }
        #endregion IEnumerable<T>

        #region Skadowe z interfejsu IEnumerable
        System.Collections.IEnumerator
            System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion

        public T Value { get; }  // Automatycznie generowana waciwo z samym getterem (z wersji C# 6.0). 

        public Pair<BinaryTree<T>> SubItems { get; set; }
    }
}
