﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_06
{
    public sealed class ProductSerialNumber
    {
        public ProductSerialNumber(
            string productSeries, int model, long id)
        {
            ProductSeries = productSeries;
            Model = model;
            Id = id;
        }

        public string ProductSeries { get; }
        public int Model { get; }
        public long Id { get; }


        public override int GetHashCode()
        {
            int hashCode = ProductSeries.GetHashCode();
            hashCode ^= Model;  // Operacja XOR
            hashCode ^= Id.GetHashCode();  // Operacja XOR
            return hashCode;
        }

        public override bool Equals(object obj)
        {
            if(obj == null)
            {
                return false;
            }
            if(ReferenceEquals(this, obj))
            {
                return true;
            }
            if(this.GetType() != obj.GetType())
            {
                return false;
            }
            return Equals((ProductSerialNumber)obj);
        }

        public bool Equals(ProductSerialNumber obj)
        {
            // KROK 3. Sprawdzanie, czy typy pasują do siebie.
            // if (this.GetHashCode() != obj.GetHashCode())
            // {
            //    return false;
            // } 

            // KROK 4. Sprawdzanie wyniku wywołania base.Equals, jeśli 
            // w klasie bazowej przesłonięta jest metoda Equals().
            // System.Diagnostics.Debug.Assert(
            //     base.GetType() != typeof(object));
            // if ( base.Equals(obj) )
            // {
            //    return false;
            // } 

            // KROK 1. Sprawdzanie czy obiekt jest różny od null.
            return ((obj != null)
                // KROK 5. Sprawdzanie, czy pola z identyfikatorem są równe.
                && (ProductSeries == obj.ProductSeries) &&
                (Model == obj.Model) &&
                (Id == obj.Id));
        }

        public static bool operator ==(
            ProductSerialNumber leftHandSide,
            ProductSerialNumber rightHandSide)
        {

            // Sprawdzanie, czy parametr leftHandSide jest równy null.  
            // (operator== would be recursive)
            if(ReferenceEquals(leftHandSide, null))
            {
                // Zwraca true, jeśli parametr rightHandSide też jest równy null.
                // W przeciwnym razie zwraca false.
                return ReferenceEquals(rightHandSide, null);
            }

            return (leftHandSide.Equals(rightHandSide));
        }

        public static bool operator !=(
            ProductSerialNumber leftHandSide,
            ProductSerialNumber rightHandSide)
        {
            return !(leftHandSide == rightHandSide);
        }
    }

}
