﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_02
{
    public struct Coordinate
    {
        public Coordinate(Longitude longitude, Latitude latitude)
        {
            Longitude = longitude;
            Latitude = latitude;
        }

        public Longitude Longitude { get; }
        public Latitude Latitude { get; }


        public override int GetHashCode()
        {
            int hashCode = Longitude.GetHashCode();
            // Jeśli skróty nie są równe 
            if(Longitude.GetHashCode() != Latitude.GetHashCode())
            {
                hashCode ^= Latitude.GetHashCode();  // Wykonywana jest operacja XOR
            }
            return hashCode;
        }

        public override string ToString()
        {
            return string.Format("{0} {1}", Longitude, Latitude);
        }

    }

    public struct Longitude { }
    public struct Latitude { }
}