﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_07
{
    using System;
    class Program
    {
        static void Main()
        {
            // ...

            Angle angle = new Angle(25, 58, 23);
            object objectAngle = angle;  // Opakowywanie
            Console.Write(((Angle)objectAngle).Degrees);

            // Wypakowywanie, modyfikowanie wypakowanej wartości i usuwanie tej wartości
            ((Angle)objectAngle).MoveTo(26, 58, 23);
            Console.Write(", " + ((Angle)objectAngle).Degrees);

            // Opakowywanie, modyfikowanie opakowanej wartości i usuwanie referencji do opakowanej wartości
            ((IAngle)angle).MoveTo(26, 58, 23);
            Console.Write(", " + ((Angle)angle).Degrees);

            // Bezpośrednie modyfikowanie opakowanej wartości
            ((IAngle)objectAngle).MoveTo(26, 58, 23);
            Console.WriteLine(", " + ((Angle)objectAngle).Degrees);

            // ...
        }
    }

    interface IAngle
    {
        void MoveTo(int hours, int minutes, int seconds);
    }

    struct Angle : IAngle
    {
        public Angle(int degrees, int minutes, int seconds)
        {
            _Degrees = degrees;
            _Minutes = minutes;
            _Seconds = seconds;
        }

        // UWAGA: To rozwiązanie sprawia, że typ Angle staje się modyfikowalny. Jest
        //        to sprzeczne ze wskazówkami.
        public void MoveTo(int degrees, int minutes, int seconds)
        {
            _Degrees = degrees;
            _Minutes = minutes;
            _Seconds = seconds;
        }

        public int Degrees
        {
            get { return _Degrees; }
        }
        private int _Degrees;

        public int Minutes
        {
            get { return _Minutes; }
        }
        private int _Minutes;

        public int Seconds
        {
            get { return _Seconds; }
        }
        private int _Seconds;
    }
}
