﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_21
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            Employee employee1 = new Employee();

            employee1.Name = "Inigo Montoya";
            System.Console.WriteLine(employee1.Name);

            // ...
        }
    }

    class Employee
    {
        // Właściwość FirstName
        public string FirstName
        {
            get
            {
                return _FirstName;
            }
            set
            {
                _FirstName = value;
            }
        }
        private string _FirstName;

        // Właściwość LastName
        public string LastName
        {
            get
            {
                return _LastName;
            }
            set
            {
                _LastName = value;
            }
        }
        private string _LastName;
        // ...

        // Właściwość Name
        public string Name
        {
            get
            {
                return $"{ FirstName } { LastName }";
            }
            set
            {
                // Rozbijanie przypisanej wartości na imię i nazwisko.
                string[] names;
                names = value.Split(new char[] { ' ' });
                if(names.Length == 2)
                {
                    FirstName = names[0];
                    LastName = names[1];
                }
                else
                {
                    // Zgłaszanie wyjątku, jeśli nie przypisano
                    // imienia i nazwiska.
                    throw new System.ArgumentException(
                        $"Przypisana wartość '{ value }' jest nieprawidłowa",
                        "value");
                }
            }
        }

        public string Initials => $"{ FirstName[0] } { LastName[0] }";

        // Właściwość Title
        public string Title { get; set; }

        // Właściwość Manager
        public Employee Manager { get; set; }
    }
}
