namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_04
{
    public class Program
    {
        public static void Main()
        {
            string firstName;
            string lastName;
            string fullName;
            string initials;

            System.Console.WriteLine("Hej, ty!");

            firstName = GetUserInput("Wprowad imi: ");
            lastName = GetUserInput("Wprowad nazwisko: ");

            fullName = GetFullName(firstName, lastName);
            initials = GetInitials(firstName, lastName);
            DisplayGreeting(fullName, initials);
        }

        static string GetUserInput(string prompt)
        {
            System.Console.Write(prompt);
            return System.Console.ReadLine();
        }

        static string GetFullName(  // Metoda z ciaem w postaci wyraenia wprowadzona w C# 6.0.
              string firstName, string lastName) =>
                  $"{ firstName } { lastName }";


        static void DisplayGreeting(string fullName, string initials)
        {
            System.Console.WriteLine(
                $"Witaj, { fullName }! Twoje inicjay to { initials }");
            return;
        }

        static string GetInitials(string firstName, string lastName)
        {
            return $"{ firstName[0] }. { lastName[0] }.";
        }

    }
}
