﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_07
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            Contact contact = new Contact();
            contact.Name = "Inigo Montoya";

            // BŁĄD: właściwość 'PdaItem.ObjectKey' jest niedostępna
            // z powodu poziomu ochrony.
            //contact.ObjectKey = Guid.NewGuid(); // Jeśli przeniesiesz ten wiersz poza komentarz,
                                                  // kod się nie skompiluje
        }
    }

    public class PdaItem
    {
        protected Guid ObjectKey { get; set; }

        // ...
    }

    public class Contact : PdaItem
    {
        void Save()
        {
            // Tworzenie obiektu typu FileStream z nazwą pliku
            // w formacie <ObjectKey>.dat.
            FileStream stream = System.IO.File.OpenWrite(
                ObjectKey + ".dat");
        }

        void Load(PdaItem pdaItem)
        {
            // BŁĄD: właściwość 'pdaItem.ObjectKey' jest niedostępna
            // z powodu poziomu ochrony
            //pdaItem.ObjectKey =...;

            Contact contact = pdaItem as Contact;
            if(contact != null)
            {
                contact.ObjectKey = new Guid();//...; 
            }
        }
        // ...
        public string Name { get; set; }
    }
}
