﻿using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_11.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_NoArgs_ExpectErrors()
        {
            string[] args = new string[0];
            string view =
@"BŁĄD: należy podać adres URL i nazwę pliku.
Użytkowanie: Downloader.exe <URL> <nazwa_docelowego_pliku>";

            IntelliTect.ConsoleView.Tester.Test(view,
            () =>
            {
                Program.Main(args);
            });
        }

        [TestMethod]
        public void Main_GoodArgs_DownloadFile()
        {
            string[] args = { "http://google.com", System.Environment.CurrentDirectory + "\\destination.txt" };

            Assert.AreEqual(0, Program.Main(args));
        }
    }
}