﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter13.Listing13_18
{
    using System;

    public class Thermostat
    {
        // ...
        // Deklarowanie pola typu delegata w celu 
        // zapisania listy subskrybentów.
        private EventHandler<TemperatureArgs> _OnTemperatureChange;

        public void add_OnTemperatureChange(
            EventHandler<TemperatureArgs> handler)
        {
            System.Delegate.Combine(_OnTemperatureChange, handler);
        }

        public void remove_OnTemperatureChange(
            EventHandler<TemperatureArgs> handler)
        {
            System.Delegate.Remove(_OnTemperatureChange, handler);
        }

        //public event EventHandler<TemperatureArgs> OnTemperatureChange
        //{
        //    // Ten kod spowoduje błąd kompilacji.
        //    add
        //    {
        //        add_OnTemperatureChange(value);
        //    }
        //    // Ten kod spowoduje błąd kompilacji.
        //    remove
        //    {
        //        remove_OnTemperatureChange(value);
        //    }
        //}

        public class TemperatureArgs : System.EventArgs
        {
            public TemperatureArgs(float newTemperature)
            {
            }

        }
    }
}