#include "gd.h"
#include "gdfonts.h"
#include "gdfontmb.h"
#include "gdfontt.h"
#include <string.h>
#include <stdio.h>

int main(int argc, char **argv) {
  char *s;
  int width;
  int scale;
  FILE * out;
  gdImagePtr image;
  int white, black, red, blue;
  int mon, tues, wed, thur, fri;
  char str[3];
  
  if(argc != 6) {
    printf("Naley poda 5 cen akcji w cigu tygodnia.\n");
    return 0;
  }
  
  image = gdImageCreate(200,220);
  white = gdImageColorAllocate(image, 255, 255, 255);
  black = gdImageColorAllocate(image,   0,   0,   0);
  red   = gdImageColorAllocate(image, 255,   0,   0);
  blue  = gdImageColorAllocate(image,   0,   0, 255);
  
  /* Najpierw narysujemy osie na wykresie */
  gdImageLine( image, 20, 20, 20, 170, black);
  gdImageLine( image, 20, 170, 180, 170, black);

  /* Teraz dodajmy do nich etykiety */

  s = "Dzien tygodnia";
  gdImageString( image, gdFontMediumBold, 
                 (100 - (strlen(s) * gdFontMediumBold->w)/2),
                 (195 - gdFontMediumBold->h), s, black);

  s = "Cena akcji";
  gdImageStringUp( image, gdFontMediumBold,
                   (15 - gdFontMediumBold->h),
                   (100 + (strlen(s) * gdFontMediumBold->w)/2),
                   s, black);

  /* Dodajemy etykiety poszczeglnych dni tygodnia */
  width = gdFontSmall->w;
  gdImageChar(image, gdFontSmall, (30  - (width/2)), 172, 'P', black);
  gdImageChar(image, gdFontSmall, (65  - (width/2)), 172, 'W', black);
  gdImageChar(image, gdFontSmall, (100 - (width/2)), 172, 'S', black);
  gdImageChar(image, gdFontSmall, (135 - (width/2)), 172, 'C', black);
  gdImageChar(image, gdFontSmall, (170 - (width/2)), 172, 'P', black);

  sscanf(argv[1], "%d", &mon);
  sscanf(argv[2], "%d", &tues);
  sscanf(argv[3], "%d", &wed);
  sscanf(argv[4], "%d", &thur);
  sscanf(argv[5], "%d", &fri);

  scale = 75 / ((mon + tues + wed + thur + fri)/5);
  mon  *=scale;
  tues *=scale;
  wed  *=scale;
  thur *=scale;
  fri  *=scale;

  gdImageArc(image, 30 , (170 - mon), 5, 5, 0, 360, red);
  gdImageArc(image, 65 , (170 - tues), 5, 5, 0, 360, red);
  gdImageArc(image, 100, (170 - wed), 5, 5, 0, 360, red);
  gdImageArc(image, 135, (170 - thur), 5, 5, 0, 360, red);
  gdImageArc(image, 170, (170 - fri), 5, 5, 0, 360, red);

  gdImageLine(image, 30 , (170 - mon), 65 , (170 - tues), black);
  gdImageLine(image, 65 , (170 - tues), 100, (170 - wed), black);
  gdImageLine(image, 100, (170 - wed), 135, (170 - thur), black);
  gdImageLine(image, 135, (170 - thur), 170, (170 - fri), black);

  sprintf( str, "%d", mon);
  gdImageString(image, gdFontTiny, 35 , (160 - mon), argv[1], blue);
  sprintf( str, "%d", tues);
  gdImageString(image, gdFontTiny, 60 , (160 - tues), argv[2], blue);
  sprintf( str, "%d", wed);
  gdImageString(image, gdFontTiny, 100, (160 - wed), argv[3], blue);
  sprintf( str, "%d", thur);
  gdImageString(image, gdFontTiny, 135, (160 - thur), argv[4], blue);
  sprintf( str, "%d", fri);
  gdImageString(image, gdFontTiny, 170, (160 - fri), argv[5], blue);

  out = fopen("stockchart.gif");
  gdImageGif(image, out);
  fclose(out);
  gdImageDestroy(image);
  return 0;
}
