#!/usr/bin/perl
use GD;

if($#ARGV != 4) {
    die "Naley poda 5 cen akcji w cigu tygodnia.\n";
}
  
$image = new GD::Image(200,220) || die;
$white = $image->colorAllocate(255, 255, 255);
$black = $image->colorAllocate(  0,   0,   0);
$red   = $image->colorAllocate(255,   0,   0);
$blue  = $image->colorAllocate(  0,   0, 255);
  

$image->line( 20, 20, 20, 170, black);
$image->line( 20, 170, 180, 170, black);

$s = "Dzien tygodnia";
$image->string( gdMediumBoldFont, 
                (100 - (strlen($s) * gdMediumBoldFont->width)/2),
                (195 - gdMediumBoldFont->height), $s, $black);

$s = "Cena akcji";
$image->stringUp(gdMediumBoldFont,
                  (15 - gdMediumBoldFont->height)
                  (100 + (strlen($s) * gdMediumBoldFont->width )/2),
                  $s, $black);

$width = gdSmallFont->width;
$image->char(gdSmallFont, (30  - ($width/2)), 172, 'P', $black);
$image->char(gdSmallFont, (65  - ($width/2)), 172, 'W', $black);
$image->char(gdSmallFont, (100 - ($width/2)), 172, 'S', $black);
$image->char(gdSmallFont, (135 - ($width/2)), 172, 'C', $black);
$image->char(gdSmallFont, (170 - ($width/2)), 172, 'P', $black);

($mon, $tues, $wed, $thur, $fri) = @ARGV;  

$scale = 75 / (($mon + $tues + $wed + $thur + $fri)/5);

$image->arc(30 , (170 - ($mon * $scale)), 5, 5, 0, 360, $red);
$image->arc(65 , (170 - ($tues * $scale)), 5, 5, 0, 360, $red);
$image->arc(100, (170 - ($wed * $scale)), 5, 5, 0, 360, $red);
$image->arc(135, (170 - ($thur * $scale)), 5, 5, 0, 360, $red);
$image->arc(170, (170 - ($fri * $scale)), 5, 5, 0, 360, $red);

$image->line(30 , (170 - ($mon * $scale)), 65 , (170 - ($tues * $scale)), $black);
$image->line(65 , (170 - ($tues * $scale)), 100, (170 - ($wed * $scale)), $black);
$image->line(100, (170 - ($wed * $scale)), 135, (170 - ($thur * $scale)), $black);
$image->line(135, (170 - ($thur * $scale)), 170, (170 - ($fri * $scale)), $black);

$image->string(gdTinyFont, 35 , (160 - ($mon * $scale)), $mon, $blue);
$image->string(gdTinyFont, 60 , (160 - ($tues * $scale)), $tues, $blue);
$image->string(gdTinyFont, 100, (160 - ($wed * $scale)), $wed, $blue);
$image->string(gdTinyFont, 135, (160 - ($thur * $scale)), $thur, $blue);
$image->string(gdTinyFont, 170, (160 - ($fri * $scale)), $fri, $blue);


$gif_data = $image->gif;
open(GIF, ">stockchart.gif") || die;
print GIF $gif_data;
close GIF;
