#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

void spc_make_fd_nonblocking(int fd) {
  int flags;

  flags = fcntl(fd, F_GETFL);  /* Odczyt przecznikw zwizanych z deskryptorem. */
  if (flags == -1) {
    perror("Bd funkcji spc_make_fd_nonblocking dla F_GETFL");
    exit(-1);
  }
  flags |= O_NONBLOCK;
  /* Teraz przeczniki bd takie same, jak wczeniej poza ustawieniem O_NONBLOCK.
   */
  if (fcntl(fd, F_SETFL, flags) == -1) {
    perror("Bd funkcji spc_make_fd_nonblocking dla F_SETFL");
    exit(-1);
  }
}

