#include <openssl/sha.h>
#include <openssl/rsa.h>
#include <openssl/objects.h>
#include <openssl/rand.h>
#include <string.h>

#define MIN(x,y) ((x) > (y) ? (y) : (x))

unsigned char *generate_and_package_128_bit_secret(RSA *recip_pub_key,
                      RSA *signers_key, unsigned char *sec, unsigned int *olen) {
  unsigned char *tmp = 0, *to_encrypt = 0, *sig = 0, *out = 0, *p, *ptr;
  unsigned int  len, ignored, b_per_ct;
  int           bytes_remaining; /* NIE MOE BY LICZB BEZ ZNAKU. */
  unsigned char hash[20];

  /* Generuje tajne dane. */
  if (!RAND_bytes(sec, 16)) return 0;

  /* Musimy teraz podpisa zarwno klucz publiczny, jak i tajne dane. Naley
   * skopiowa do bufora tmp tajne dane, klucz publiczny oraz wykadnik.
   */
  len = 16 + RSA_size(recip_pub_key) + BN_num_bytes(recip_pub_key->e);
  if (!(tmp = (unsigned char *)malloc(len))) return 0;
  memcpy(tmp, sec, 16);
  if (!BN_bn2bin(recip_pub_key->n, tmp + 16)) goto err;
  if (!BN_bn2bin(recip_pub_key->e, tmp + 16 + RSA_size(recip_pub_key))) goto err;

  /* Podpisujemy teraz bufor tmp (dokadnie jego skrt SHA1) i ponownie
   * przydzielamy przestrze w pamici dla podpisu.
   */
  if (!(sig = (unsigned char *)malloc(BN_num_bytes(signers_key->n)))) goto err;
  if (!SHA1(tmp, len, hash)) goto err;
  if (!RSA_sign(NID_sha1, hash, 20, sig, &ignored, signers_key)) goto err;

  /* Liczba bajtw, ktr moemy kadorazowo zaszyfrowa, jest ograniczona przez
   * rozmiar moduu oraz wymagania zwizane z dopenianiem.
   */
  b_per_ct = RSA_size(recip_pub_key) - (2 * 20 + 2);

  if (!(to_encrypt = (unsigned char *)malloc(16 + RSA_size(signers_key))))
    goto err;

  /* Wyraenie poprzedzajce symbol mnoenia reprezentuje liczb operacji
   * szyfrowania, ktre mamy zamiar wykona. Drugim skadnikiem mnoenia jest
   * dugo danych wyjciowych kadego z tych operacji mnoenia.
   */
  *olen = ((16 + RSA_size(signers_key) + b_per_ct - 1) / b_per_ct) *
          RSA_size(recip_pub_key);
  if (!(out = (unsigned char *)malloc(*olen))) goto err;

  /* Kopiuje dane przeznaczone do zaszyfrowania do pojedynczego bufora. */
  ptr = to_encrypt;
  bytes_remaining = 16 + RSA_size(signers_key);
  memcpy(to_encrypt, sec, 16);
  memcpy(to_encrypt + 16, sig, RSA_size(signers_key));
  p = out;

  while (bytes_remaining > 0) {
    /* szyfruje b_per_ct bajtw a do ostatniej iteracji, w ktrej liczba
     * szyfrowanych bajtw moe by mniejsza.
     */
    if (!RSA_public_encrypt(MIN(bytes_remaining,b_per_ct), ptr, p,
                           recip_pub_key, RSA_PKCS1_OAEP_PADDING)) {
        free(out);
        out = 0;
        goto err;
    }
    bytes_remaining -= b_per_ct;
    ptr += b_per_ct;
    /* Naley pamita, e dane wyjciowe s wiksze od danych wejciowych. */
    p += RSA_size(recip_pub_key);
  }

err:
  if (sig) free(sig);
  if (tmp) free(tmp);
  if (to_encrypt) free(to_encrypt);
  return out;
}

