#include <stdio.h>
#include <string.h>
#include <openssl/evp.h>
#include <openssl/hmac.h>
#include <sys/types.h>  /* na niektrych platformach netinet/in.h */
#include <netinet/in.h> /* na niektrych platformach arpa/inet.h */
#include <arpa/inet.h>  /* dla funkcji htonl */

#ifdef WIN32
typedef unsigned __int64 spc_uint64_t;
#else
typedef unsigned long long spc_uint64_t;
#endif

/* Ta warto musi reprezentowa rozmiar danych wyjciowych naszej funkcji
 * pseudolosowej (PRF)!
 */
#define PRF_OUT_LEN 20

/* Implementacja funkcji PRF PBKDF2 zgodnej ze standardem PKCS#5 i wykorzystujcej
 * algorytm HMAC-SHA1. Funkcja zawsze generuje 20-bajtowe dane wyjciowe.
 */

/* Pierwsze trzy funkcje s wewntrznymi funkcjami pomocniczymi. */
static void pkcs5_initial_prf(unsigned char *p, size_t plen, unsigned char *salt,
                               size_t saltlen, size_t i, unsigned char *out,
                               size_t *outlen) {
  size_t        swapped_i;
  HMAC_CTX      ctx;

  HMAC_CTX_init(&ctx);
  HMAC_Init(&ctx, p, plen, EVP_sha1());
  HMAC_Update(&ctx, salt, saltlen);
  swapped_i = htonl(i);
  HMAC_Update(&ctx, (unsigned char *)&swapped_i, 4);
  HMAC_Final(&ctx, out, (unsigned int *)outlen);
}

/* Ponisza funkcja PRF nie zmienia si w kolejnych wywoaniach, jednak powyej
 * obsuylimy konkatenacj argumentw salt oraz i wewntrz samej funkcji, zamiast
 * poza t funkcj, poniewa w ten sposb implementacja tego rozwizania jest
 * prostsza.
*/
static void pkcs5_subsequent_prf(unsigned char *p, size_t plen, unsigned char *v,
                                  size_t vlen, unsigned char *o, size_t *olen) {
  HMAC_CTX ctx;

  HMAC_CTX_init(&ctx);
  HMAC_Init(&ctx, p, plen, EVP_sha1());
  HMAC_Update(&ctx, v, vlen);
  HMAC_Final(&ctx, o, (unsigned int *)olen);
}

static void pkcs5_F(unsigned char *p, size_t plen, unsigned char *salt,
                     size_t saltlen, size_t ic, size_t bix, unsigned char *out) {
  size_t        i = 1, j, outlen;
  unsigned char ulast[PRF_OUT_LEN];

  memset(out,0,  PRF_OUT_LEN);
  pkcs5_initial_prf(p, plen, salt, saltlen, bix, ulast, &outlen);
  while (i++ < ic) {
    for (j = 0;  j < PRF_OUT_LEN;  j++) out[j] ^= ulast[j];
    pkcs5_subsequent_prf(p, plen, ulast, PRF_OUT_LEN, ulast, &outlen);
  }
  for (j = 0;  j < PRF_OUT_LEN;  j++) out[j] ^= ulast[j];
}

void spc_pbkdf2(unsigned char *pw, unsigned int pwlen, char *salt,
                 spc_uint64_t saltlen, unsigned int ic, unsigned char *dk,
                 spc_uint64_t dklen) {
  unsigned long i, l, r;
  unsigned char final[PRF_OUT_LEN] = {0,};

  if (dklen > ((((spc_uint64_t)1) << 32) - 1) * PRF_OUT_LEN) {
    /* Wywouje procedur obsugi bdu. */
    abort();
  }
  l = dklen / PRF_OUT_LEN;
  r = dklen % PRF_OUT_LEN;
  for (i = 1;  i <= l;  i++)
    pkcs5_F(pw, pwlen, salt, saltlen, ic, i, dk + (i - 1) * PRF_OUT_LEN);
  if (r) {
    pkcs5_F(pw, pwlen, salt, saltlen, ic, i, final);
    for (l = 0;  l < r;  l++) *(dk + (i - 1) * PRF_OUT_LEN + l) = final[l];
  }
}

