#include <sys/param.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>

static int   orig_ngroups = -1;
static gid_t orig_gid = -1;
static uid_t orig_uid = -1;
static gid_t orig_groups[NGROUPS_MAX];

void spc_drop_privileges(int permanent) {
  gid_t newgid = getgid(), oldgid = getegid();
  uid_t newuid = getuid(), olduid = geteuid();

  if (!permanent) {
    /* Zapisz informacje o usuwanych uprawnieniach, aby mona je byo pniej
     * przywrci.
     */

    orig_gid = oldgid;
    orig_uid = olduid;
    orig_ngroups = getgroups(NGROUPS_MAX, orig_groups);
  }

  /* Jeli uprawnienia uytkownika root maj zosta usunite, upewnij si, e
   * zredukowae pomocnicze grupy dla danego procesu, zanim przystpisz do
   * pozostaych dziaa, poniewa wywoanie systemowe setgroups() wymaga
   * uprawnie uytkownika root. Usu grupy pomocnicze niezalenie od tego,
   * czy uprawnienia bd usuwane tymczasowo czy trwale.
   */
  if (!olduid) setgroups(1, &newgid);

  if (newgid != oldgid) {
#if !defined(linux)
    setegid(newgid);
    if (permanent && setgid(newgid) == -1) abort();
#else
    if (setregid((permanent ? newgid : -1), newgid) == -1) abort();
#endif
  }

  if (newuid != olduid) {
#if !defined(linux)
    seteuid(newuid);
    if (permanent && setuid(newuid) == -1) abort();
#else
    if (setregid((permanent ? newuid : -1), newuid) == -1) abort();
#endif
  }

  /* Sprawd, czy wprowadzanie zmian przebiego pomylnie */
  if (permanent) {
    if (newgid != oldgid && (setegid(oldgid) != -1 || getegid() != newgid))
      abort();
    if (newuid != olduid && (seteuid(olduid) != -1 || geteuid() != newuid))
      abort();
  } else {
    if (newgid != oldgid && getegid() != newgid) abort();
    if (newuid != olduid && geteuid() != newuid) abort();
  }
}

void spc_restore_privileges(void) {
  if (geteuid() != orig_uid)
    if (seteuid(orig_uid) == -1 || geteuid() != orig_uid) abort();
  if (getegid() != orig_gid)
    if (setegid(orig_gid) == -1 || getegid() != orig_gid) abort();
  if (!orig_uid)
    setgroups(orig_ngroups, orig_groups);
}

