//---------------------------------------------------------------------------
#ifndef FlashingH
#define FlashingH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\StdCtrls.hpp>
//---------------------------------------------------------------------------
//
// Definicja nowego typu dla potrzeb funkcji obsugi zdarzenia - nasza
// funkcja pobiera parametr typu TObject* i referencj do zmiennej bool.
//
typedef void __fastcall
  (__closure *TMyEvent)(System::TObject *Sender, bool& Stop);

class PACKAGE TFlashingLabel : public TCustomLabel
{
private:
  //
  // Pola prywatne
  //
  bool  FFlashEnabled;
  int   FFlashRate;
  int   FFlashLimit;
  int   FlashCount;
  TMyEvent FOnLimitReached;
  TTimer* Timer;
protected:
  //
  // Chronione metody zapisu pl.
  //
  void __fastcall SetFlashEnabled(bool AFlashEnabled);
  void __fastcall SetFlashRate(int AFlashRate);
  //
  // Funkcja LimitReached() - generuje zdarzenie OnLimitReached.
  //
  virtual void __fastcall LimitReached();
  //
  // Metoda Click() jest przedefiniowana wycznie dla ilustracji
  // przedefiniowywania obsugi zdarze klasy bazowej.
  // Jest to funkcja dynamiczna, wywoywana po kadym
  // klikniciu w obszarze komponentu.
  //
  __declspec(dynamic) void __fastcall Click();
  //
  // Funkcja obsugi zdarzenia OnTimer
  //
  virtual void __fastcall OnTimer(TObject* Sender);
public:
	__fastcall TFlashingLabel(TComponent* Owner);
__published:
  //
  // Waciwoci komponentu
  //
  __property bool FlashEnabled =
    {read=FFlashEnabled, write=SetFlashEnabled, default=true};
  __property int FlashRate =
    {read=FFlashRate, write=SetFlashRate, default=800};
  __property int FlashLimit =
    {read=FFlashLimit, write=FFlashLimit, default=0};
  //
  // Zdarzenie OnLimitReached
  //
  __property TMyEvent OnLimitReached =
    {read=FOnLimitReached, write=FOnLimitReached};
  //
  // Redeklarowane waciwoci klasy TCustomLabel
  //
	__property Align ;
	__property Alignment ;
	__property AutoSize ;
	__property Caption ;
	__property Color ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property FocusControl ;
	__property Font ;
	__property ParentColor ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ShowAccelChar ;
	__property ShowHint ;
	__property Transparent ;
	__property Layout ;
	__property Visible ;
	__property WordWrap ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
};
//---------------------------------------------------------------------------
#endif
