//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Flashing.h"

#pragma package(smart_init)
//---------------------------------------------------------------------------
// Sprawdzanie, czy komponenty nie definiuj czystych funkcji wirtualnych
// realizuje metoda ValidCtrCheck().
//

static inline void ValidCtrCheck(TFlashingLabel *)
{
	new TFlashingLabel(NULL);
}
//---------------------------------------------------------------------------
__fastcall TFlashingLabel::TFlashingLabel(TComponent* Owner)
	: TCustomLabel(Owner)
{
  //
  // Ustaw domylne wartoci pl.
  //
  FFlashEnabled = true;
  FFlashRate = 800;
  FFlashLimit = 0;
  FlashCount = 0;
  //
  // Zainicjalizuj zegar
  //
  Timer = new TTimer(this);
  //
  // Ustaw czstotliwo migania.
  //
  Timer->Interval = FlashRate;
  //
  // Skojarz funkcj obsugi zdarzenia OnTimer komponentu
  // ze zdarzeniem OnTimer zegara.
  //
  Timer->OnTimer = OnTimer;
}
//---------------------------------------------------------------------------

void __fastcall TFlashingLabel::SetFlashEnabled(bool AFlashEnabled)
{
  //
  // Ustaw pole FFlashEnabled.
  //
  FFlashEnabled = AFlashEnabled;
  //
  // Nie uruchamiaj zegara w trybie projektowania -
  // w takiej sytuacji naley zakoczy prac funkcji.
  //
  if (ComponentState.Contains(csDesigning)) return;
  //
  // Uruchom zegar.
  //
  Timer->Enabled = FFlashEnabled;
  //
  // Upewnij si, e po wyczeniu migania tre
  // etykiety pozostaje widoczna.
  //
  if (!FFlashEnabled) Visible = true;
}

void __fastcall TFlashingLabel::SetFlashRate(int AFlashRate)
{
  //
  // Ustal jednoczenie zawarto pola FFlashRate
  // i czstotliwo pracy zegara.
  //
  Timer->Interval = FFlashRate = AFlashRate;
}

void __fastcall TFlashingLabel::OnTimer(TObject* Sender)
{
  //
  // W trybie projektowania wycz zegar i zakocz
  // dziaanie funkcji.
 //
  if (ComponentState.Contains(csDesigning)) {
    Timer->Enabled = false;
    return;
  }
  //
  // Za kadym odebraniem zdarzenia OnTimer przecz
  // stan widzialnoci komponentu.
  //
  Visible = !Visible;
  //
  // Wygeneruj zdarzenie.
  // Jeli etykieta jest widzialna, zwiksz licznik.
  //
  if (FFlashLimit && Visible)  {
    //
    // Zwiksz licznik zawarty w polu FlashCount.
    //
    FlashCount++;
    //
    // Jeli zawarto licznika (FlashCount) jest wiksza
    // lub rwna wartoci FlashLimit, wyzeruj licznik
    // i wygeneruj zdarzenie OnLimitReached.
    //
    if (FlashCount >= FFlashLimit) {
      FlashCount = 0;
      LimitReached();
    }
  }
}

void __fastcall TFlashingLabel::LimitReached()
{
  //
  // Nadaj domyln warto false parametrowi Stop.
  // Warto ta bdzie zwracana, jeli uytkownik
  // nie zmodyfikuje parametru w treci funkcji.
  //
  bool stop = false;
  //
  // Tu wyzwalane jest zdarzenie. Jeli zdefiniowano
  // funkcj jego obsugi, wywoaj j.
  //
  if (OnLimitReached) OnLimitReached(this, stop);
  //
  // Ustal warto waciwoci FlashEnabled na podstawie
  // wartoci parametru Stop.
  //
  FlashEnabled = !stop;
  //
  // Daj gos
  //
  MessageBeep(-1);
}

void __fastcall TFlashingLabel::Click()
{
  //
  // Daj sygna dwikowy i wywoaj metod Click() klasy
  // bazowej, realizujc domyln obsug zdarzenia.
  //
  MessageBeep(-1);
  TCustomLabel::Click();
}

namespace Flashing
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TFlashingLabel)};
		RegisterComponents("Samples", classes, 0);
	}
}
//---------------------------------------------------------------------------
