//---------------------------------------------------------------------------
#include <vcl\vcl.h>
//
// Poniszy plik zawiera deklaracj funkcji PlaySound().
//
#include <vcl\mmsystem.hpp>
#pragma hdrstop

#include "JJMain.h"
#pragma package(smart_init)
#pragma resource "*.dfm"
//
// identyfikatory acuchw
//
#define IDS_UP    101
#define IDS_DOWN  102

HINSTANCE DLLInstance;

TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner),
  done(false)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  DLLInstance = LoadLibrary("resource.dll");
  if (!DLLInstance) {
    MessageBox(Handle, "Bd adowania biblioteki RESOURCE.DLL.",
      "Bd", MB_OK);
    Start->Enabled = false;
    Stop->Enabled = false;
    return;
  }
  //
  // Zaaduj i wywietl pierwszy obrazek.
  //
  Image->Picture->Bitmap->
    LoadFromResourceName((int)DLLInstance, "ID_BITMAP1");
}
//---------------------------------------------------------------------
void __fastcall TMainForm::StartClick(TObject *Sender)
{
  //
  // Kliknicie przycisku Start uruchamia ptl animacji.
  // Poniewa identyfikatory map bitowych maj nazwy od
  // ID_BITMAP1 do ID_BITMAP5, bdziemy je tworzy
  // z acucha "ID_BITMAP" przez doczanie kolejnych
  // numerw.
   //
  String s = "ID_BITMAP";
  //
  // bufor na acuchy
  //
  char buff[10];
  //
  // znacznik zakoczenia pracy
  //
  done = false;
  //
  // Rozpoczynamy ptl - bdzie si wykonywaa a
  // do kliknicia przycisku Stop.
  //
  while (!done) {
    //
    // Rysuj mapy bitowe od 1 do 5.
    //
    //
    for (int i=1;i<6;i++) {
      //
      // Docz warto zmiennej i do acucha w celu
      // utworzenia identyfikatora mapy bitowej.
      //
      String resName = s + String(i);
      //
      // Wywietl map bitow.
      //
      DrawImage(resName);
    }
    //
    // Zaaduj acuch "Gra" za pomoc funkcji Windows API
    // LoadString(), wywietl acuch i zadaj od systemu
    // ponownego wywietlenia etykiety.
    //
    LoadString(DLLInstance, IDS_UP, buff, sizeof(buff));
    Label->Caption = buff;
    Label->Refresh();
    //
    // Zagraj dwik (asymchronicznie) za pomoc
    // funkcji PlaySound() Windows API.
    //
    PlaySound("ID_WAVEUP",
      DLLInstance, SND_ASYNC | SND_RESOURCE);
    //
    // Zaczekaj momencik.
    //
    Sleep(200);
    //
    // ... i to samo jeszcze raz, tylko w odwrotnej kolejnoci
    //
    for (int i=5;i>0;i--) {
      String resName = s + String(i);
      DrawImage(resName);
    }
    PlaySound("ID_WAVEDOWN",
      DLLInstance, SND_ASYNC | SND_RESOURCE);
    LoadString(DLLInstance, IDS_DOWN, buff, sizeof(buff));
    Label->Caption = buff;
    Label->Refresh();
    Sleep(200);
  }
}
//---------------------------------------------------------------------
void __fastcall TMainForm::StopClick(TObject *Sender)
{
  //
  // Kliknito przycisk Stop - koniec pracy.
  //
  done = true;
}
//---------------------------------------------------------------------
//
// Funkcja wywietla map bitow.
//
void
TMainForm::DrawImage(String& name)
{
  //
  // Zaaduj map bitow z zasobw uywajc
  // nazwy przekazanej w parametrze.
  //
  Image->Picture->Bitmap->
    LoadFromResourceName((int)DLLInstance, name);
  //
  // Aby system mg wywietli obrazek, trzeba
  // wymusi przetworzenie oczekujcych komunikatw.
  //
  Application->ProcessMessages();
  //
  // opnienie
  //
  Sleep(20);
}
//---------------------------------------------------------------------
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
  FreeLibrary(DLLInstance);
}
//---------------------------------------------------------------------------

