//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "GrdientU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormPaint(TObject *Sender)
{
  // Utwrz map bitow w pamici.
  Graphics::TBitmap* bitmap = new Graphics::TBitmap;
  bitmap->Width = Width;
  bitmap->Height = Height;

  // Tablica kolorw
  const int num = 64;
  TColor colors[num];

  // Utwrz palet o 64 odcieniach bkitu.
  // Operacja ta jest niepotrzebna, jeli sterownik graficzny
  // pracuje w trybie wicej ni 256-kolorowym.
  LOGPALETTE* logPal =
    (LOGPALETTE*)new char[(sizeof(LOGPALETTE) +
    (num - 1) * sizeof(PALETTEENTRY))];
  logPal->palVersion = 0x300;
	for (int i=0;i<num;i++) {
		logPal->palPalEntry[i].peBlue = i * (256/num);
  	logPal->palPalEntry[i].peRed = 0;
  	logPal->palPalEntry[i].peGreen = 0;
		logPal->palPalEntry[i].peFlags = 0;
  // Dodaj kolor do palety. Ustaw najbardziej znaczcy bajt koloru
  // na 2, co wymusi pobieranie kolorw z palety logicznej.
    colors[num - i - 1] =
      TColor(RGB(0, 0, i * (256/num)) | 0x02000000);
	}
  HPALETTE hPal = CreatePalette(logPal);

  // Podstaw utworzon palet do mapy bitowej.
  bitmap->Palette = hPal;

  // Wyrysuj zadan liczb poziomych pasw, kady w odpowiednim
  // odcieniu bkitu wzitym z tablicy kolorw.
	int size = (ClientHeight/num) + 1;
	int i;
	for (i=0;i<num;i++) {
		RECT rect =
      Rect(0, i*size, ClientWidth, (i*size) + size);
    bitmap->Canvas->Brush->Color = colors[i];
		bitmap->Canvas->FillRect(rect);
	}

  // Skopiuj map bitow z pamici na ekran.
  Canvas->Draw(0, 0, bitmap);

  // Posprztaj po sobie.
  delete bitmap;
  delete logPal;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormResize(TObject *Sender)
{
  // Formularz bdzie rysowany podczas kadej zmiany rozmiarw.
  FormPaint(this);
}
//---------------------------------------------------------------------------

