//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "CaptureU.h"
#include "Capture2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CaptureBtnClick(TObject *Sender)
{
  // Utwrz obiekt klasy TCanvas reprezentujcy pulpit.
  TCanvas* dtCanvas = new TCanvas;
  dtCanvas->Handle = GetDC(0);

  // Utwrz obiekt klasy TBitmap i ustaw jego rozmiary tak,
  // by byy rwne rozmiarom formularza.
  Graphics::TBitmap*
    bitmap = new Graphics::TBitmap;
  bitmap->Width = Width;
  bitmap->Height = Height;

  // Utwrz palet z ustawie okienka formularza i przypisz j
  // waciwoci Palette mapy bitowej
  int nColors =
    GetDeviceCaps(Canvas->Handle, SIZEPALETTE);
  LOGPALETTE* logPal = (LOGPALETTE*)new Byte[
     sizeof(LOGPALETTE) + (nColors - 1) *
     sizeof(PALETTEENTRY)];
  logPal->palVersion  = 0x300;
  logPal->palNumEntries = (Word)nColors;
  GetSystemPaletteEntries(Canvas->Handle,
    0, nColors, logPal->palPalEntry);
  bitmap->Palette = CreatePalette(logPal);
  delete[] logPal;

  // Skopiuj fragment ekranu do mapy bitowej.
  TRect src = BoundsRect;
  TRect dest = Rect(0, 0, Width, Height);
  bitmap->Canvas->CopyRect(dest, dtCanvas, src);

  // Zapisz go na dysku.
  bitmap->SaveToFile("form.bmp");

  // Posprztaj po sobie i poegnaj si.
  delete bitmap;
  delete dtCanvas;
  ResultsBtn->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ResultsBtnClick(TObject *Sender)
{
  ResultsForm->ShowModal();
}
//---------------------------------------------------------------------------
