//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MsgMain.h"
#include "InstForm.h"
#include "MsgTBox.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShowTBoixClick(TObject *Sender)
{
  //
  // Wywietl palet narzdzi
  //
  ToolBox->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HatchedClick(TObject *Sender)
{
  //
  // Po zaznaczeniu jednego z pl wyboru wyrysuj formularz
  // ponownie aby wygenerowac komunikat WM_ERASEBKGND.
  //
  Repaint();
  //
  // Jeli zaznaczono pole ta domylnego,
  // zablokuj pole kreskowania.
  //
  if (Sender == LetVCLHandle) {
    Hatched->Enabled = !LetVCLHandle->Checked;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::InstructionsClick(TObject *Sender)
{
  //
  // Wywietl okienko z instrukcjami
  //
  InstructForm->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall
TMainForm::OnMyMessage(TMessage& Message)
{
  //
  // Funkcja obsugi komunikatu zdefiniowanego przez uytkownika.
  // Odczytuje acuch przekazany w parametrze WParam
  // i wywietla go w okienku. Dodatkowo genenruje
  // sygna dwikowy.
  //
  String msg =
    "Komunikat specjalny!!\n\n"
    "Nacinity przycisk palety: " +
    String((char*)Message.WParam);
  MessageBeep(-1);
  Application->MessageBox(
    msg.c_str(), "Komunikat od palety", MB_OK);
}

void __fastcall
TMainForm::OnNCHitTest(TWMNCHitTest& Message)
{
  //
  // Funkcja obsugi komunikatu WM_NCHITTEST.
  // "Oszukuje" ona okienko symulujc kliknicie w pasku
  // tytuu, podczas gdy w rzeczywistoci nastpio ono
  // w polu roboczym. W tym celu wystarczy wywoa domyln
  // procedur obsugi komunikatu i jeli klikniciu nastpio
  // w polu roboczym, zmieni zawarto pola Result
  // na HTCAPTION.
  //
  DefaultHandler(&Message);
  if (Message.Result == HTCLIENT)
    Message.Result = HTCAPTION;
}

void __fastcall
TMainForm::OnEraseBkgnd(TWMEraseBkgnd& Message)
{
  //
  // Funkcja obsugi komunikatu WM_ERASEBKGND.
  // Jeli zaznaczono pole "To domylne",
  // wystarczy wywoa metod TForm::Dispatch()
  // w celu zapewnienia domylnej obsugi komunikatu.
  //
  if (LetVCLHandle->Checked) {
    TForm::Dispatch(&Message);
    return;
  }
  //
  // Struktura TWMEraseBkgnd udostpnia uchwyt kontekstu
  // urzdzenia uywanego przy rysowaniu ta.
  // Na podstawie uchwytu mona utworzy tymczasowy
  // obiekt TCanvas w celu wyrysowania ta.
  //
  TCanvas* canvas = new TCanvas();
  canvas->Handle = Message.DC;
  if (Hatched->Checked) {
    canvas->Brush->Handle =
      CreateHatchBrush(HS_DIAGCROSS, clMaroon);
  }
  else
    canvas->Brush->Color = clMaroon;
  canvas->FillRect(ClientRect);
  Message.Result = true;
  delete canvas;
}

void __fastcall
TMainForm::OnGetMinMaxInfo(TWMGetMinMaxInfo& Message)
{
  //
  // Funkcja obsugi komunikatu WM_GETMINMAXINFO.
  // Ogranicza zakres zmian rozmiarw okienka aplikacji
  // do 500 x 360 (maksimum) i 360 x 260 (minimum).
  //
  Message.MinMaxInfo->ptMaxTrackSize.x = 500;
  Message.MinMaxInfo->ptMaxTrackSize.y = 360;
  Message.MinMaxInfo->ptMinTrackSize.x = 360;
  Message.MinMaxInfo->ptMinTrackSize.y = 260;
  Message.Result = 0;
}
