//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "EHMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;

//
// Definicja prostej klasy obsugujcej wyjtki.
//
//
class MyEHClass {
  public:
    MyEHClass(int error, char* msg)
    {
      ErrorCode = error;
      Msg = msg;
    }
    int Error()
    {
      return ErrorCode;
    }
    String Message()
    {
      return Msg;
    }
    int Message(char* buff, int buffsize)
    {
      if (Msg.Length() < buffsize) {
        strcpy(buff, Msg.c_str());
        return Msg.Length();
      }
      else {
        strcpy(buff, "");
        return 0;
      }
    }
  private:
    int ErrorCode;
    String Msg;
};

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ThrowItClick(TObject *Sender)
{
  //
  // Wywoaj funkcj DoIt() w sekcji try.
  // Spowoduje to wygenerowanie wyjtku, ktry
  // zostanie przechwycony przez jedn z piciu
  // poniszych sekcji catch.
  //
  try {
    DoIt();
  }
  catch (char* buff) {
    MessageBeep(-1);
    Label->Caption =
      "Wyjtek (char*): " + String(buff);
  }
  catch (String str) {
    MessageBeep(-1);
    Label->Caption =
      "Wyjtek (String): " + str;
  }
  catch (int error) {
    MessageBeep(-1);
    String str = "Wyjtek (int) numer " + String(error);
    Label->Caption = str;
  }
  catch (MyEHClass& e) {
    MessageBeep(-1);
    Label->Caption = e.Message();
  }
  catch (EInvalidGraphic& e) {
    MessageBeep(-1);
    Label->Caption = "Wyjtek biblioteki VCL: " + e.Message;
  }
}
//---------------------------------------------------------------------
void TMainForm::DoIt()
{
  //
  // Wygeneruj komunikat o wyjtku w zalenoci od
  // wybranej opcji.
  //
  switch (RadioGroup->ItemIndex)
  {
    case 0 : throw (125);
    case 1 : throw ("Bd obsugi acucha");
    case 2 : throw (String("Niewaciwy parametr"));
    case 3 : {
      MyEHClass eh(110, "Wyjtek klasy MyEHClass.");
      throw (eh);
    }
    case 4 : {
      TImage* image = new TImage(0);
      image->Picture->LoadFromFile("ehtest.exe");
    }
    case 5 : {
      //
      // Wywoujemy powaniejsz awari
      //
      TStringList* list;
      delete list;
    }
  }
}

void __fastcall
TMainForm::OnException(TObject *Sender, Exception *E)
{
  //
  // Tutaj przechwytujemy nieobsuone wyjtki
  // Wywietl komunikat generowany przez VCL...
  //
  String str =
    "Nie obsuony wyjtek: " + E->Message;
  Label->Caption = str;
  Label->Refresh();
  for (int i=0;i<4;i++) {
    MessageBeep(-1);
    Sleep(500);
  }
  //
  // ... i okienko informacyjne.
  //
  Application->ShowException(E);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  Application->OnException = OnException;
}
//---------------------------------------------------------------------------
