//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StatMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SimpleClick(TObject *Sender)
{
  //
  // Ustaw waciwo SimplePanel paska statusowego
  // zgodnie ze stanem zaznaczenia opcji Prosty.
  // Pozwala to na eksperymenty z postaci paska.
  //
  StatusBar->SimplePanel = Simple->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OvrModeClick(TObject *Sender)
{
  //
  // Po klikniciu ktrego z pl opcji w pasku
  // statusowym naley go wyrysowa ponownie.
  //
  StatusBar->Repaint();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExtendedSelClick(TObject *Sender)
{
  //
  // If either of the mode check boxes are clicked then
  // redraw the status bar.
  //
  StatusBar->Repaint();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  //
  // Ustaw wskanik do funkcji obsugi zdarzenia OnHint
  // aplikacji na nasz funkcj OnHint()
  //
  Application->OnHint = OnHint;
}
//---------------------------------------------------------------------------
void _fastcall TMainForm::OnHint(TObject* Sender)
{
  //
  // Jeli pasek statusowy pracuje w trybie prostym,
  // jego waciwo SimpleText pobierana jest z waciwoci
  // Hint aplikacji. W przeciwnym przypadku tekst waciwoci Hint
  // umieszczany jest w pierwszym polu paska.
  //
  if (StatusBar->SimplePanel)
    StatusBar->SimpleText = Application->Hint;
  else
    StatusBar->Panels->Items[0]->Text = Application->Hint;
}
void __fastcall TMainForm::StatusBarDrawPanel(TStatusBar *StatusBar,
      TStatusPanel *Panel, const TRect &Rect)
{
  //
  // Dla uproszczenia tworzymy referencj
  // do waciwoci Canvas paska statusowego
  //
  TCanvas& c = *StatusBar->Canvas;
  //
  // Utwrz tymczasowy obiekt klasy TRect (parametr Rect
  // jest zadeklarowany jako const i niemodyfikowalny).
  //
  TRect temp = Rect;
  //
  // Sprawd, czy potrzebne jest przerysowanie panela nr 3.
  // Jeli tak, wyrysuj na panelu ikon.
  //
 if (Panel->Index == 3) {
    //
    // Zaaduj standardow ikon IDI_HAND Windows.
    // Tym razem atwiej bdzie nam uy wywoania API.
    //
    HICON icon = LoadIcon(NULL, IDI_HAND);
    //
    // Wyrysuj ikon, zmniejsz j do rozmiaru 15 na 15
    // pikseli i wyrodkuj w panelu.
    //
   DrawIconEx(c.Handle, Rect.Left + 6, 3, icon,
      15, 15, NULL, NULL, DI_NORMAL);
    //
    // i to wszystko.
    //
    return;
  }
  //
  // Ponisza konstrukcja warunkowa sprawdza, czy
  // wybrano opcj zastpowania znakw lub rozszerzonego
  // wyboru. Jeli tak, musimy nada tekstowi odpowiedni
  // wygld przez wyrysowanie go dwa razy: pierwszy
  // przebieg to wykrelenie tekstu w kolorze biaym,
  // nastpnie przesuwamy go o 1 piksel i wywietlamy
  // w kolorze szarym, uzyskujc efekt zablokowania.
  //
  if ((Panel->Index == 1 && OvrMode->Checked == false) ||
    (Panel->Index == 2 && ExtendedSel->Checked == false)) {
      //
      // Przesu o 1 piksel w d i w prawo.
      //
      temp.Left += 1;
      temp.Top += 2;
      //
      // Zmie kolor na biay.
      //
      c.Font->Color = clWhite;
      //
      // Zmie to na przezroczyste, aby biay
      // tekst by widoczny spod szarego.
      //
      //
      c.Brush->Style = bsClear;
      //
      // Wyrysuj tekst funkcj API DrawText().
      // Umoliwia ona wyrodkowanie tekstu w pionie
      // i w poziomie wewntrz zadanego obszaru.
      //
      //
      DrawText(c.Handle, Panel->Text.c_str(),
        -1, (RECT*)&temp, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
      //
      // Ustaw kolor na szary - bdziemy go uywa do
      // wywietlenia tekstu.
      //
      c.Font->Color = clGray;
      //
      // Przywr pierwotne wsprzdne prostokta.
      //
      temp.Left -= 1;
      temp.Top -= 2;
  }
  //
  // Wywietl tekst. Jeli opcja jest aktywna,
  // uyj do rysowania koloru czarnego.
  // Jeli opcja jest zablokowana, uyj kombinacji
  // szarego i biaego jak opisano powyej.
  //
  DrawText(c.Handle, Panel->Text.c_str(),
    -1, (RECT*)&temp, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
}
//---------------------------------------------------------------------------
