//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "SPMain.h"
#include "SPAbout.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TScratchPad *ScratchPad;
//---------------------------------------------------------------------------
__fastcall TScratchPad::TScratchPad(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileExitClick(TObject *Sender)
{
  //
  // Koniec pracy - zamknij okno gwne.
  //
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditCutClick(TObject *Sender)
{
  //
  // Wywoaj metod TMemo::CutToClipboard().
  //
  Memo->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditCopyClick(TObject *Sender)
{
  //
  // Wywoaj metod TMemo::CopyToClipboard().
  //
  Memo->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditPasteClick(TObject *Sender)
{
  //
  // Wywoaj metod TMemo::PasteFromClipboard().
  //
  Memo->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileNewClick(TObject *Sender)
{
  //
  // Tworzy nowy dokument. Przed utworzeniem zachowuje
  // w razie potrzeby biec zawarto edytora.
  //
  if (Memo->Modified) {
    //
    // Wywietl okienko dialogowe z pytaniem
    //
    int result = Application->MessageBox(
      "Biecy dokument zosta zmieniony. Czy zachowa zmiany?",
      "Uwaga", MB_YESNOCANCEL | MB_ICONWARNING);
    //
    // Kliknito przycisk Tak
    //
     if (result == IDYES) FileSaveClick(Sender);
    //
    // Kliknito przycisk Nie
    //
    if (result == IDCANCEL) return;
  }
  //
  // Usu wszystkie wiersze w polu edycyjnym
  //
  if (Memo->Lines->Count > 0) Memo->Clear();
  //
  // Ustaw waciwo FileName okienka zapisania pliku
  // na pusty acuch. Oznacza to, e tekst jeszcze
  // nie zosta zachowany.
  //
  SaveDialog->FileName = "";
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileOpenClick(TObject *Sender)
{
  //
  // Otwiera plik, uprzednio zachowujc poprzedni
  // zawarto edytora.
  //
  if (Memo->Modified) {
  	int result = Application->MessageBox(
      "Biecy dokument zosta zmieniony. Czy zachowa zmiany?",
      "Uwaga", MB_YESNOCANCEL | MB_ICONWARNING);
     if (result == IDYES) FileSaveClick(0);
    if (result == IDCANCEL) return;
  }
  //
  // Wywietla okienko dialogowe otwarcia pliku. Usuwa zawarto
  // waciwoci FileName. Jeli kliknito OK, otwiera plik za
  // pomoc metody LoadFromFile().
  //
  OpenDialog->FileName = "";
  if (OpenDialog->Execute())
  {
    if (Memo->Lines->Count > 0) Memo->Clear();
     Memo->Lines->LoadFromFile(OpenDialog->FileName);
    SaveDialog->FileName = OpenDialog->FileName;
  }
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileSaveClick(TObject *Sender)
{
  //
  // Jeeli wczeniej podano nazw, nie ma potrzeby
  // otwierania okienka dialogowego zapisywania pliku.
  // Mona od razu wywoa metod SaveToFile().
  //
  if (SaveDialog->FileName != "")
  {
    Memo->Lines->SaveToFile(SaveDialog->FileName);
    //
    // Zerujemy znacznik modyfikacji - plik zosta ju zapisany.
    //
    Memo->Modified = false;
  }
  //
  // Nie podano nazwy pliku - trzeba zapyta uytkownika.
  //
  else FileSaveAsClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileSaveAsClick(TObject *Sender)
{
  //
  // Wywietla okienko dialogowe zapisania pliku.
  // Zeruje znacznik modyfikacji - plik zosta zapisany.
  //
  SaveDialog->Title = "Zapisz jako";
  if (SaveDialog->Execute())
  {
    Memo->Lines->SaveToFile(SaveDialog->FileName);
    Memo->Modified = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditUndoClick(TObject *Sender)
{
  //
  // Poniewa komponent TMemo nie posiada metody obsugujcej
  // polecenie Cofnij, musimy uy komunikatu WM_UNDO Windows.
  //
  SendMessage(Memo->Handle, WM_UNDO, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditSelectAllClick(TObject *Sender)
{
  //
  // Wywoaj metod TMemo::SelectAll().
  //
  Memo->SelectAll();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditWordWrapClick(TObject *Sender)
{
  //
  // Przecz stan waciwoci TMemo::WordWrap.
  // Po przeczeniu zaznacz nowy stan w menu Edycja.
  //
  Memo->WordWrap = !Memo->WordWrap;
  EditWordWrap->Checked = Memo->WordWrap;
  //
  // Jeli dzielenie wierszy jest wczone, wystarczy pionowy
  // pasek przesuwu, w przeciwnym przypadku obydwa.
  //
  if (Memo->WordWrap) Memo->ScrollBars = ssVertical;
  else Memo->ScrollBars = ssBoth;
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::OnHint(TObject* Sender)
{
  StatusBar->SimpleText = Application->Hint;
}
void __fastcall TScratchPad::FormCreate(TObject *Sender)
{
  Application->OnHint = OnHint;
  Application->OnIdle = OnIdle;
}
//---------------------------------------------------------------------------

void __fastcall TScratchPad::HelpAboutClick(TObject *Sender)
{
  AboutBox->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall
TScratchPad::OnIdle(TObject* Sender, bool& Done)
{
  //
  // Udostpnienie polece Wytnij i Kopiuj. Jeli tekst
  // nie jest zaznaczony, naley zablokowa polecenia
  // w menu gwnym, lokalnym i w pasku narzdzi.
  //
  bool textSelected = Memo->SelLength > 0;
  EditCut->Enabled = textSelected;
  EditCutBtn->Enabled = textSelected;
  PopupCut->Enabled = textSelected;
  EditCopy->Enabled = textSelected;
  EditCopyBtn->Enabled = textSelected;
  PopupCopy->Enabled = textSelected;
  //
  // Udostpnienie polecenia Wklej. Jest ono dostpne,
  // jeli w schowku znajduje si tekst.
  //
  bool cbHasText = Clipboard()->HasFormat(CF_TEXT);
  EditPaste->Enabled = cbHasText;
  EditPasteBtn->Enabled = cbHasText;
  PopupPaste->Enabled = cbHasText;
  //delete clipBrd;
  //
  // Udostpnienie polecenia Zaznacz wszystko
  //
  bool hasText = Memo->Lines->Count > 0;
  EditSelectAll->Enabled = hasText;
  //
  // Udostpnienie polece Zapisz i Zapisz jako.
  //
  bool modified = Memo->Modified;
  FileSave->Enabled = modified && hasText;
  FileSaveBtn->Enabled = modified && hasText;
  FileSaveAs->Enabled = modified && hasText;
  //
  // Udostpnienie polecenia Cofnij.
  //
  EditUndo->Enabled = modified;
}

void __fastcall TScratchPad::FilePrintClick(TObject *Sender)
{
  //
  // Wywietl dialog Drukuj
  //
  if (PrintDialog->Execute()) {
    //
    // Ustal nagwek dla obiektu Printer.
    //
    Printer()->Title =
      "Notesik - " + OpenDialog->FileName;
    //
    // Ustaw czcionk drukarki na uyt w polu edycyjnym.
    //
    Printer()->Canvas->Font = Memo->Font;
    //
    // Ustal wysoko wierszy na podstawie wielkoci czcionki
    // i rozdzielczoci drukarki. Poniewa wynik moe by ujemny,
    // pozbd si znaku za pomoc funkcji abs().
    // Dodaj do wyniku 40% na interlini.
    //
    //
    //
    int lineHeight = abs(
      MulDiv(Printer()->Canvas->Font->Size,
      GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 72));
    lineHeight *= 1.4;
    //
    // Ustal liczb wierszy na stronie. Odejmij trzy
    // wiersze na dolny margines.
    //
    int linesPerPage =
      (Printer()->PageHeight/lineHeight) - 4;
    //
    // Rozpocznij wydruk od wiersza 4 w celu pozostawienia
    // miejsca na nagwek i grny margines.
    //
    int lineCount = 4;
    //
    // Najpierw nagwek strony.
    //
    Printer()->BeginDoc();
    TRect rect;
    rect.Top = lineHeight;
    rect.Left = 20;
    rect.Right =  Printer()->PageWidth;
    rect.Bottom = lineHeight * 2;
    DrawText(Printer()->Handle,
      OpenDialog->FileName.c_str(), -1, (RECT*)&rect, DT_CENTER);
    //
    // Ptla drukujca poszczeglne wiersze.
    //
    for (int i=0;i<Memo->Lines->Count;i++) {
      //
      // Na kocu strony naley wyzerowa licznik wierszy,
      // wysun stron z drukarki i rozpocz wydruk nowej.
       //
      if (lineCount++ == linesPerPage) {
        PrintFooter(rect, lineHeight);
        lineCount = 4;
        Printer()->NewPage();
      }
      //
      // Wydruk kolejnego acucha funkcj TextOut().
      //
      String s = Memo->Lines->Strings[i];
      Printer()->Canvas->TextOut
        (0, lineCount * lineHeight, s);
    }
    //
    // Koniec drukowania.
    //
    PrintFooter(rect, lineHeight);
    Printer()->EndDoc();
  }
}
//---------------------------------------------------------------------------
void TScratchPad::PrintFooter(TRect& rect, int lineHeight)
{
  //
  // Utwrz cig znakw zawierajcy numer strony w stopce.
  // Poniewa funkcja DrawText() wymaga parametru typu char*,
  // uyjemy tego typu zamiast String.
  //
  char buff[10];
  wsprintf(buff, "Strona %d", Printer()->PageNumber);
  //
  // Zdefiniuj prostoktny obszar zawierajcy stopk.
  // Powinien si znajdowa kilka wierszy powyej
  // koca strony.
  //
  rect.Top = Printer()->PageHeight - (lineHeight * 2);
  rect.Bottom = rect.Top + lineHeight;
  //
  // Uyj funkcji DrawText() do wywietlenia tekstu
  // (pozwala to na atwe wyrodkowanie).
  //
  DrawText(Printer()->Handle, buff, -1, (RECT*)&rect, DT_CENTER);
  //
  // Narysuj lini powyej tekstu stopki.
  //
  Printer()->Canvas->MoveTo(0, rect.Top - 2);
  Printer()->Canvas->LineTo(rect.Right, rect.Top - 2);
}

void __fastcall TScratchPad::FilePrintSetupClick(TObject *Sender)
{
  PrinterSetupDialog->Execute();
}
//---------------------------------------------------------------------------

