#include <iostream.h>
#include <stdio.h>
#pragma hdrstop

#include "airplane.h"
//
// Inicjalizacja obiektu
//
Airplane::Airplane(const char* _name, int _type) :
  type(_type),
  status(ONRAMP),
  speed(0),
  altitude(0),
  heading(0)
{
  switch (type) {
    case AIRLINER : ceiling = 35000; break;
    case COMMUTER : ceiling = 20000; break;
    case PRIVATE  : ceiling = 8000;
  }
  name = new char[50];
  strcpy(name, _name);
}
//
// Usunicie obiektu
//
Airplane::~Airplane()
{
  delete[] name;
}
//
// Odbir polecenia kontrolera lotw
//
bool
Airplane::SendMessage(int msg, char* response,
  int spd, int dir, int alt)
{
  strcpy(response, "");
  //
  // Weryfikacja polecenia kontrolera
  //
  if (spd > 900) {
    strcat(response, "Prdko nie moe przekracza 900 km/h.");
    return false;
  }
  if (dir > 360) {
    strcat(response, "Kurs nie moe by wikszy od 360 stopni.");
    return false;
  }
  if (alt < 100 && alt != -1) {
    strcat(response, "Chcesz, zebym sie rozbi?!");
    return false;
  }
  if (alt > ceiling) {
    strcat(response, "To dla mnie za wysoko.");
    return false;
  }
  //
  // Wykonaj czynno dan poleceniem
  //
  switch (msg) {
    case MSG_TAKEOFF : {
      // Nie mona startowa bdc ju w powietrzu
      if (status != ONRAMP) {
        strcat(response, "Jestem w powietrzu!");
        return false;
      }
      TakeOff(dir);
      break;
    }
    case MSG_CHANGE : {
      // Nie mona zmieni parametrw lotu na ziemi
      if (status == ONRAMP) {
        strcat(response, "Jestem na ziemi!");
        return false;
      }
       // Zmiana parametrw tylko jeli argument rny od -1
      if (spd != -1) speed = spd;
      if (dir != -1) heading = dir;
      if (alt != -1) altitude = alt;
      status == CRUISING;
      break;
    }
    case MSG_LAND : {
      if (status == ONRAMP) {
        strcat(response, "Jestem na ziemi!");
        return false;
      }
      Land();
      break;
    }
    case MSG_REPORT : ReportStatus();
  }
  //
  // Potwierdzenie wykonania polecenia.
  //
  strcat(response, "Wykonaem.");
  return true;
}
//
// Start
//
void
Airplane::TakeOff(int dir)
{
  heading = dir;
  status = TAKINGOFF;
}
//
// Ldowanie
//
void
Airplane::Land()
{
  speed = heading = altitude = 0;
  status = ONRAMP;
}
//
// Utwrz raport o parametrach lotu
//
int
Airplane::GetStatus(char* statusString)
{
  sprintf(statusString, "%s: Wysoko: %d, Kurs: %d, "
    "Prdko: %d", name, altitude, heading, speed);
  return status;
}
//
// Wywietl raport na ekranie
//
void
Airplane::ReportStatus()
{
  char buff[100];
  GetStatus(buff);
  cout << endl << buff << endl;
}

