//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "SMTPTstU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
//
// Uwaga: uycie domylnej nazwy serwera SMTP "mail" moe
// w niektrych systemach okaza si niewystarczacjce.
// W takiej sytuacji naley jawnie wpisa nazw serwera
// SMTP do waciwoci Host komponentu SMTP.
// Jeli serwer wykorzystuje mechanizm autoryzacji dostpu,
// konieczne jest rwnie podanie legalnej nazwy uytkownika
// we waciwoci UserID.
//
void __fastcall TMainForm::ConnectBtnClick(TObject *Sender)
{
  SMTP->Host = "mail";

  SMTP->Connect();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SMTPSuccess(TObject *Sender)
{
  StatusBar->SimpleText = "Wysano.";
  SMTP->Disconnect();
  DisconnectBtn->Enabled = false;
  SendBtn->Enabled = false;
  ConnectBtn->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SMTPFailure(TObject *Sender)
{
  StatusBar->SimpleText = "Bd transmisji!";
  SMTP->Disconnect();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SendBtnClick(TObject *Sender)
{
  SMTP->PostMessage->FromAddress = FromEdit->Text;
  SMTP->PostMessage->ToAddress->Add(ToEdit->Text);
  SMTP->PostMessage->Subject = SubjectEdit->Text;
  SMTP->PostMessage->Body->Assign(Message->Lines);
  SMTP->SendMail();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DisconnectBtnClick(TObject *Sender)
{
  StatusBar->SimpleText = "Poczenie przerwane.";
  SMTP->Disconnect();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SMTPConnect(TObject *Sender)
{
  StatusBar->SimpleText = "Poczenie nawizane.";
  DisconnectBtn->Enabled = true;
  SendBtn->Enabled = true;
  ConnectBtn->Enabled = false;
  // Najlepiej byoby wysa wiadomo automatycznie po nawizaniu
  // poczenia. Niestety, do chwili publikacji ksiki problem
  // z obsug zdarzenia OnConnect nie zosta rozwizany.
  // Mona go jednak obej przez generacj w chwili poczenia
  // zdarzenia uytkownika i wysanie wiadomoci w ramach odpowiedzi
  // na to ostatnie.
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SMTPDisconnect(TObject *Sender)
{
  // Zdarzenie to jest generowane nawet po likwidacji obiektu
  // (bd ten nie zosta usunity do chwili publikacji ksiki).
  // Ponisza instrukcja zapobiega takiej sytuacji i wynikajcemu
  // z niej bdowi ochrony dostpu do pamici.
  if (!SendBtn) return;

  DisconnectBtn->Enabled = false;
  SendBtn->Enabled = false;
  ConnectBtn->Enabled = true;
}
//---------------------------------------------------------------------------

